/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.AdaptableVector;
import dr.math.matrixAlgebra.ReadableMatrix;
import dr.math.matrixAlgebra.ReadableVector;
import dr.math.matrixAlgebra.WrappedMatrix;

public class AdaptableCovariance {
    private final int dim;
    private final double[][] empirical;
    private final AdaptableVector.Default means;
    protected int updates;
    protected int counts;

    public AdaptableCovariance(int n) {
        this.dim = n;
        this.empirical = new double[n][n];
        this.means = new AdaptableVector.Default(n);
        this.updates = 0;
        this.counts = 0;
    }

    public int getUpdateCount() {
        return this.updates;
    }

    public void update(ReadableVector readableVector) {
        assert (readableVector.getDim() == this.dim);
        ++this.counts;
        if (this.shouldUpdate()) {
            ++this.updates;
            this.means.update(readableVector);
            if (this.updates > 1) {
                this.updateVariance(readableVector);
            }
        }
    }

    public ReadableMatrix getCovariance() {
        double[][] dArray = new double[this.dim][this.dim];
        for (int i = 0; i < this.dim; ++i) {
            dArray[i] = (double[])this.empirical[i].clone();
        }
        return new WrappedMatrix.ArrayOfArray(dArray);
    }

    public ReadableVector getMean() {
        return this.means.getMean();
    }

    protected boolean shouldUpdate() {
        return true;
    }

    private void updateVariance(ReadableVector readableVector) {
        for (int i = 0; i < this.dim; ++i) {
            for (int j = i; j < this.dim; ++j) {
                this.empirical[i][j] = this.calculateCovariance(this.empirical[i][j], readableVector, i, j);
                this.empirical[j][i] = this.empirical[i][j];
            }
        }
        if (this.updates > 100) {
            double d = 0.0;
        }
    }

    private double calculateCovariance(double d, ReadableVector readableVector, int n, int n2) {
        double d2 = d * (double)(this.updates - 2);
        d2 += readableVector.get(n) * readableVector.get(n2);
        d2 += (double)(this.updates - 1) * this.means.getOldMeans(n) * this.means.getOldMeans(n2) - (double)this.updates * this.means.getNewMeans(n) * this.means.getNewMeans(n2);
        return d2 /= (double)(this.updates - 1);
    }

    public class WithSubsampling
    extends AdaptableCovariance {
        final int minCounts;

        public WithSubsampling(int n, int n2) {
            super(n);
            this.minCounts = n2;
        }

        @Override
        protected boolean shouldUpdate() {
            return this.minCounts < this.counts;
        }
    }
}

