% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyseCRT.R
\name{CRTanalysis}
\alias{CRTanalysis}
\title{Analysis of cluster randomized trial with spillover}
\usage{
CRTanalysis(
  trial,
  method = "GEE",
  distance = "nearestDiscord",
  scale_par = NULL,
  cfunc = "L",
  link = "logit",
  numerator = "num",
  denominator = "denom",
  excludeBuffer = FALSE,
  alpha = 0.05,
  baselineOnly = FALSE,
  baselineNumerator = "base_num",
  baselineDenominator = "base_denom",
  personalProtection = FALSE,
  clusterEffects = TRUE,
  spatialEffects = FALSE,
  requireMesh = FALSE,
  inla_mesh = NULL
)
}
\arguments{
\item{trial}{an object of class \code{"CRTsp"} or a data frame containing locations in (x,y) coordinates, cluster
assignments (factor \code{cluster}), and arm assignments (factor \code{arm}) and outcome data (see details).}

\item{method}{statistical method with options:
\tabular{ll}{
\code{"EMP"} \tab simple averages of the data   \cr
\code{"T"}   \tab comparison of cluster means by t-test \cr
\code{"GEE"} \tab Generalised Estimating Equations \cr
\code{"LME4"} \tab Generalized Linear Mixed-Effects Models \cr
\code{"INLA"}\tab Integrated Nested Laplace Approximation (INLA) \cr
\code{"MCMC"}\tab Markov chain Monte Carlo using \code{"JAGS"} \cr
\code{"WCA"}\tab Within cluster analysis \cr
}}

\item{distance}{Measure of distance or surround with options: \cr
\tabular{ll}{
\code{"nearestDiscord"} \tab distance to nearest discordant location (km)\cr
\code{"disc"} \tab disc\cr
\code{"kern"} \tab surround based on sum of normal kernels\cr
\code{"hdep"} \tab Tukey half space depth\cr
\code{"sdep"} \tab simplicial depth\cr
}}

\item{scale_par}{numeric: pre-specified value of the spillover parameter or disc radius for models where this is fixed (\code{cfunc = "R"}).\cr\cr}

\item{cfunc}{transformation defining the spillover function with options:
\tabular{llll}{
\code{"Z"} \tab\tab arm effects not considered\tab reference model\cr
\code{"X"} \tab\tab spillover not modelled\tab the only valid value of \code{cfunc} for methods \code{"EMP"}, \code{"T"} and \code{"GEE"}\cr
\code{"L"} \tab\tab inverse logistic (sigmoid)\tab the default for \code{"INLA"} and \code{"MCMC"} methods\cr
\code{"P"} \tab\tab inverse probit (error function)\tab available with \code{"INLA"} and \code{"MCMC"} methods\cr
\code{"S"} \tab\tab piecewise linear\tab only available with the \code{"MCMC"} method\cr
\code{"E"} \tab\tab estimation of scale factor\tab only available with \code{distance = "disc"} or \code{distance = "kern"}\cr
\code{"R"} \tab\tab rescaled linear\tab \cr
}}

\item{link}{link function with options:
\tabular{ll}{
\code{"logit"}\tab (the default). \code{numerator} has a binomial distribution with denominator \code{denominator}.\cr
\code{"log"}  \tab \code{numerator} is Poisson distributed with an offset of log(\code{denominator}).\cr
\code{"cloglog"} \tab \code{numerator} is Bernoulli distributed with an offset of log(\code{denominator}).\cr
\code{"identity"}\tab The outcome is \code{numerator/denominator} with a normally distributed error function.\cr
}}

\item{numerator}{string: name of numerator variable for outcome}

\item{denominator}{string: name of denominator variable for outcome data (if present)}

\item{excludeBuffer}{logical: indicator of whether any buffer zone (records with \code{buffer=TRUE}) should be excluded from analysis}

\item{alpha}{numeric: confidence level for confidence intervals and credible intervals}

\item{baselineOnly}{logical: indicator of whether required analysis is of effect size or of baseline only}

\item{baselineNumerator}{string: name of numerator variable for baseline data (if present)}

\item{baselineDenominator}{string: name of denominator variable for baseline data (if present)}

\item{personalProtection}{logical: indicator of whether the model includes local effects with no spillover}

\item{clusterEffects}{logical: indicator of whether the model includes cluster random effects}

\item{spatialEffects}{logical: indicator of whether the model includes spatial random effects
(available only for \code{method = "INLA"})}

\item{requireMesh}{logical: indicator of whether spatial predictions are required
(available only for \code{method = "INLA"})}

\item{inla_mesh}{string: name of pre-existing INLA input object created by \code{compute_mesh()}}
}
\value{
list of class \code{CRTanalysis} containing the following results of the analysis:
\itemize{
\item \code{description} : description of the dataset
\item \code{method} : statistical method
\item \code{pt_ests} : point estimates
\item \code{int_ests} : interval estimates
\item \code{model_object} : object returned by the fitting routine
\item \code{spillover} : function values and statistics describing the estimated spillover
}
}
\description{
\code{CRTanalysis} carries out a statistical analysis of a cluster randomized trial (CRT).
}
\details{
\code{CRTanalysis} is a wrapper for the statistical analysis packages:
\href{https://CRAN.R-project.org/package=gee}{gee},
\href{https://www.r-inla.org/}{INLA},
\href{https://CRAN.R-project.org/package=jagsUI}{jagsUI},
and the \href{https://www.rdocumentation.org/packages/stats/versions/3.6.2/topics/t.test}{t.test}
function of package \code{stats}.\cr\cr
The wrapper does not provide an interface to the full functionality of these packages.
It is specific for typical analyses of cluster randomized trials with geographical clustering. Further details
are provided in the \href{https://thomasasmith.github.io/articles/Usecase5.html}{vignette}.\cr\cr
The key results of the analyses can be extracted using a \code{summary()} of the output list.
The \code{model_object} in the output list is the usual output from the statistical analysis routine,
and can be also be inspected with \code{summary()}, or analysed using \code{stats::fitted()}
for purposes of evaluation of model fit etc..\cr\cr
For models with a complementary log-log link function specified with \code{link = "cloglog"}.
the numerator must be coded as 0 or 1. Technically the binomial denominator is then 1.
The value of \code{denominator} is used as a rate multiplier.\cr\cr
With the \code{"INLA"} and \code{"MCMC"} methods 'iid' random effects are used to model extra-Poisson variation.\cr\cr
Interval estimates for the coefficient of variation of the cluster level outcome are calculated using the method of
\href{https://www.jstor.org/stable/2685039}{Vangel (1996)}.
}
\examples{
\donttest{
example <- readdata('exampleCRT.txt')
# Analysis of test dataset by t-test
exampleT <- CRTanalysis(example, method = "T")
summary(exampleT)
# Standard GEE analysis of test dataset ignoring spillover
exampleGEE <- CRTanalysis(example, method = "GEE")
summary(exampleGEE)
# LME4 analysis with error function spillover function
exampleLME4 <- CRTanalysis(example, method = "LME4", cfunc = "P")
summary(exampleLME4)
}
}
