% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{betablockers_matrix}
\alias{betablockers_matrix}
\title{FDA Beta Blockers Adverse Events}
\format{
A matrix with 501 rows (adverse events) and 9 columns (beta blockers):
\describe{
\item{Acebutolol}{Adverse event counts for Acebutolol (integer)}
\item{Atenolol}{Adverse event counts for Atenolol (integer)}
\item{Bisoprolol}{Adverse event counts for Bisoprolol (integer)}
\item{Carvedilol}{Adverse event counts for Carvedilol (integer)}
\item{Metoprolol}{Adverse event counts for Metoprolol (integer)}
\item{Nadolol}{Adverse event counts for Nadolol (integer)}
\item{Propranolol}{Adverse event counts for Propranolol (integer)}
\item{Timolol}{Adverse event counts for Timolol (integer)}
\item{Other}{Adverse event counts for other beta blockers (integer)}
}
}
\source{
Data taken from the MDDC package version 1.1.0. Original data:
FDA Adverse Event Reporting System (FAERS) database, Q1 2021 to Q4 2023.
}
\usage{
data(betablockers_matrix)
}
\description{
This dataset, betablockers_matrix, is a matrix containing adverse event reports
from the FDA Adverse Event Reporting System (FAERS) for 9 beta blockers from Q1 2021
to Q4 2023. The matrix includes 501 adverse events (rows) across 9 medications (columns).
}
\details{
The dataset name has been kept as 'betablockers_matrix' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
CardioDataSets package and assists users in identifying its specific characteristics.
The suffix 'matrix' indicates that the dataset is a matrix object. The original content has not been modified
in any way.
}
