% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{availableATC}
\alias{availableATC}
\title{Get the names of all available Anatomical Therapeutic Chemical (ATC) classification codes}
\usage{
availableATC(cdm, level = c("ATC 1st"))
}
\arguments{
\item{cdm}{A cdm reference via CDMConnector.}

\item{level}{ATC level. Can be one or more of "ATC 1st", "ATC 2nd",
"ATC 3rd", "ATC 4th", and "ATC 5th".}
}
\value{
A vector containing the names of ATC codes for the chosen level(s)
found in the concept table of cdm.
}
\description{
Get the names of all available Anatomical Therapeutic Chemical (ATC) classification codes
}
\examples{
\donttest{
cdm <- mockVocabRef()
availableATC(cdm)
}

}
