% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_airports_list.R
\name{get_airports_list}
\alias{get_airports_list}
\title{Get the List of Airports in Colombia}
\usage{
get_airports_list()
}
\value{
A data frame with the following columns:
\itemize{
  \item \code{id}: The unique identifier of the airport.
  \item \code{name}: The name of the airport.
  \item \code{iataCode}: The IATA code of the airport (if available).
  \item \code{oaciCode}: The OACI code of the airport (if available).
  \item \code{type}: The type of airport (e.g., commercial, private).
  \item \code{longitude}: The geographical longitude of the airport.
  \item \code{latitude}: The geographical latitude of the airport.
}
}
\description{
This function retrieves a list of airports in Colombia from the public API
"https://api-colombia.com/api/v1/Airport" and returns a data frame containing
selected information about each airport, ordered by airport name in alphabetical order.
}
\details{
This function sends a GET request to the API, processes the JSON response,
and converts it into a structured data frame. The data is filtered and formatted
to include only relevant columns, and it is ordered by the \code{name} column in
alphabetical order (A to Z).

If the API returns a status code of 400, the function issues a warning message to inform
the user of the error. Any other unexpected API response is not explicitly handled and may
cause the function to fail.
}
\note{
Ensure you have an active internet connection to access the API. If the API structure changes
or the API becomes unavailable, the function may need modifications.

This function relies on the following packages: \code{httr}, \code{jsonlite}, \code{dplyr}, and \code{magrittr}.
The \code{\%>\%} operator, used for chaining commands, is provided by the \code{magrittr} package.
}
\examples{
\dontrun{
# Retrieve the list of airports
airports <- get_airports_list()

# Print the data frame
print(airports)

# View the data in a spreadsheet-like interface
View(airports)

# Select airports located in a specific city (e.g., Bogotá)
bogota_airports <- airports \%>\%
  filter(grepl("Bogotá", name))
print(bogota_airports)
}

}
\seealso{
\code{\link[httr]{GET}},
\code{\link[jsonlite]{fromJSON}},
\code{\link[dplyr]{select}},
\code{\link[dplyr]{arrange}}
}
