% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelFit.R
\name{createPrior}
\alias{createPrior}
\title{Create a Cyclops prior object}
\usage{
createPrior(priorType, variance = 1, exclude = c(), graph = NULL,
  neighborhood = NULL, useCrossValidation = FALSE, forceIntercept = FALSE)
}
\arguments{
\item{priorType}{Character: specifies prior distribution.  See below for options}

\item{variance}{Numeric: prior distribution variance}

\item{exclude}{A vector of numbers or covariateId names to exclude from prior}

\item{graph}{Child-to-parent mapping for a hierarchical prior}

\item{neighborhood}{A list of first-order neighborhoods for a partially fused prior}

\item{useCrossValidation}{Logical: Perform cross-validation to determine prior \code{variance}.}

\item{forceIntercept}{Logical: Force intercept coefficient into prior}
}
\value{
A Cyclops prior object of class inheriting from \code{"cyclopsPrior"} for use with \code{fitCyclopsModel}.
}
\description{
\code{createPrior} creates a Cyclops prior object for use with \code{\link{fitCyclopsModel}}.
}
\section{Prior types}{


We specify all priors in terms of their variance parameters.
Similar fitting tools for regularized regression often parameterize the Laplace distribution
in terms of a rate \code{"lambda"} per observation.
See \code{"glmnet"}, for example.

variance = 2 * / (nobs * lambda)^2 or lambda = sqrt(2 / variance) / nobs
}
\examples{
#Generate some simulated data:
sim <- simulateCyclopsData(nstrata = 1, nrows = 1000, ncovars = 2, eCovarsPerRow = 0.5, 
                           model = "poisson")
cyclopsData <- convertToCyclopsData(sim$outcomes, sim$covariates, modelType = "pr", 
                                    addIntercept = TRUE)

#Define the prior and control objects to use cross-validation for finding the 
#optimal hyperparameter:
prior <- createPrior("laplace", exclude = 0, useCrossValidation = TRUE)
control <- createControl(cvType = "auto", noiseLevel = "quiet")

#Fit the model
fit <- fitCyclopsModel(cyclopsData,prior = prior, control = control)  

#Find out what the optimal hyperparameter was:
getHyperParameter(fit)

#Extract the current log-likelihood, and coefficients
logLik(fit)
coef(fit)

#We can only retrieve the confidence interval for unregularized coefficients:
confint(fit, c(0))
}

