% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop.R
\name{drop}
\alias{drop}
\alias{drop.upload,UserSession-method}
\alias{drop.upload}
\title{DROP File Endpoints}
\usage{
\S4method{drop.upload}{UserSession}(
  UserSession,
  experiment_id,
  file_path,
  data_matrix_start_row = 2,
  data_matrix_start_column = 1,
  skipped_columns = c(),
  output = "default",
  timeout = UserSession@long_timeout
)
}
\arguments{
\item{UserSession}{Cytobank UserSession object}

\item{experiment_id}{integer representing an \link[=experiments]{experiment} ID}

\item{file_path}{character representing a file path}

\item{data_matrix_start_row}{integer representing the start row of the DROP file(s)}

\item{data_matrix_start_column}{integer representing the start column of the DROP file(s)}

\item{skipped_columns}{vector/list of integer(s) representing column(s) of the DROP file to skip}

\item{output}{character representing the output format \strong{[optional]}\cr
\emph{- drop.upload : \code{("default", "raw")}}\cr
\emph{- \code{dataframe}: converts the file internal compensation matrix output to a dataframe}}

\item{timeout}{integer representing the request timeout time in seconds \strong{[optional]}}
}
\description{
Upload DROP file(s) into Cytobank. A DROP file consists of any CSV, TSV, TXT, or FCS file. If the DROP file is of the type CSV, TSV, or TXT, the file will be converted to an FCS file to be used within Cytobank. \href{https://support.cytobank.org/hc/en-us/articles/206252468-How-to-analyze-gene-expression-or-imaging-data-in-Cytobank-CSV-to-FCS-}{Learn more about DROP}.
}
\details{
\code{drop.upload} Upload a DROP file (CSV, TSV, TXT, FCS) to an experiment.
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}
}
\examples{
\dontrun{# Authenticate via username/password
cyto_session <- authenticate(site="premium", username="cyril_cytometry", password="cytobank_rocks!")
# Authenticate via auth_token
cyto_session <- authenticate(site="premium", auth_token="my_secret_auth_token")
}
\dontrun{drop.upload(cyto_session, 22, file_path="/path/to/my_drop_file.type",
  data_matrix_start_row=2, data_matrix_start_column=1)
}
}
