% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chaotic.ts.R
\name{rossler.ts}
\alias{rossler.ts}
\title{Simulation of time series from the Rössler system}
\usage{
rossler.ts(a.min = 0.1, a.max = 0.2, b.min = 0.1, b.max = 0.2,
  c.min = 4, c.max = 5.7, xo.min = -2, xo.max = 2, yo.min = -10,
  yo.max = 10, zo.min = -0.2, zo.max = 0.2, time = seq(0, 100,
  0.01), transient = 1000, B = 100, doplot = TRUE)
}
\arguments{
\item{a.min}{a non-negative integer denoting a lower bound for the parameter \code{a} (Default 0).}

\item{a.max}{a non-negative integer denoting an upper bound for the parameter \code{a} (Default 0.2).}

\item{b.min}{a non-negative integer denoting a lower bound for the parameter \code{b} (Default 0).}

\item{b.max}{a non-negative integer denoting an upper bound for the parameter \code{b} (Default 0.2).}

\item{c.min}{a non-negative integer denoting a lower bound for the parameter \code{c} (Default 4).}

\item{c.max}{a non-negative integer denoting an upper bound for the parameter \code{c} (Default 5.7).}

\item{xo.min}{a non-negative integer denoting a lower bound for the initial condition \code{xo} (Default -2).}

\item{xo.max}{a non-negative integer denoting an upper bound for the initial condition \code{xo} (Default 2).}

\item{yo.min}{a non-negative integer denoting a lower bound for the initial condition \code{yo} (Default -10).}

\item{yo.max}{a non-negative integer denoting an upper bound for the initial condition \code{yo} (Default 10).}

\item{zo.min}{a non-negative integer denoting a lower bound for the initial condition \code{zo} (Default -0.2).}

\item{zo.max}{a non-negative integer denoting an upper bound for the initial condition \code{zo} (Default 0.2).}

\item{time}{a numeric vector denoting the time-lapse and the time-step (Default 'time-lapse' equal to 10001 with a 'time-step' of 0.01 seconds).}

\item{transient}{a non-negative integer denoting the number of observations that will be discarded to ensure that the values of each time serie are in the attractor (Default 1000).}

\item{B}{a non-negative integer denoting the number of series that will be generated for different values of parameters \code{a}, \code{b} and \code{c}. The number of simulated series must be at least 100 (Default 100).}

\item{doplot}{a logical value denoting if you want to draw a plot \code{TRUE} or not \code{FALSE}. If it is \code{TRUE} shows six graphs: the evolution of the temporal trajectories for the whole period, the attractor and its projections on the Cartesian plane. All of them consider the 'x-coordinate', the 'y-coordinate' and the 'z-coordinate' (Default \code{TRUE}).}
}
\value{
A list containing as many items as series we want to simulate \code{B}. Each of them has the following attributes: the value of the parameter \code{a}, the value of the parameter \code{b}, the value of the parameter \code{c}, the value of the initial condition \code{xo}, the value of the initial condition \code{yo}, the value of the initial condition \code{zo} and a time serie from the iterated Rössler system with three columns corresponding to 'x-coordinate', 'y-coordinate' and 'z-coordinate'.
}
\description{
This function simulates time series from the Rössler system considering the argument set selected by the user. Some values for the parameters and initial conditions may lead to an unstable system that will tend to infinity.
}
\examples{
## Simulates 100 time series from the Rössler system for different
## values of the parameters a, b and c in which this system exhibits
## a chaotic behaviour:
ts<-rossler.ts(a.min=0.2,a.max=0.2,b.min=0.2,b.max=0.2,c.min=5.7,c.max=5.7,
               time=seq(0,10,0.01),transient=100,B=100,doplot=TRUE)
}
\references{
Rössler, O. 1976 An equation for continuous chaos. Physics Letters A 57(5):397-398.
}
\seealso{
\code{\link{logistic.ts}}, \code{\link{henon.ts}}, \code{\link{lorenz.ts}}
}
\author{
Julio E. Sandubete, Lorenzo Escot
}
