% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{pointsEER}
\alias{pointsEER}
\title{EER Plot}
\usage{
pointsEER(
  dets,
  pch = 19,
  col = c("black", "blue", "red", "green", "yellow"),
  lwd = 3,
  ...
)
}
\arguments{
\item{dets}{An object of class "DETs".}

\item{pch}{Symbol used for plotting the EER points, by default \code{pch = 19}.}

\item{col}{A vector of colors, specifying the color of the points for each DET curve.}

\item{lwd}{Line width used for drawing symbols, by default \code{lwd = 3}.}

\item{...}{Further graphical arguments passed to the \code{points} function. For example, by default \code{pch = 19} and \code{lwd = 3} (see \code{\link{points}}, for more details).}
}
\description{
From a 'DETs' object, this function plots the EER points of each classifier within the same graph of the DETs curves.
}
\examples{
library(DET)
n = 5000
#Predictors with normal distribution
set.seed(1235)
scoreNegative1 = rnorm(n, mean = 0.25, sd = 0.125)
set.seed(5321)
scoreNegative2 = rnorm(n, mean = 0.25, sd = 0.125)
set.seed(6987)
scoreNegative3 = rnorm(n, mean = 0.25, sd = 0.125)
set.seed(11452)
scorePositive1 = rnorm(n, mean = 0.55, sd = 0.125)
set.seed(54321)
scorePositive2 = rnorm(n, mean = 0.65, sd = 0.125)
set.seed(65987)
scorePositive3 = rnorm(n, mean = 0.75, sd = 0.125)
response = as.factor(c(rep(c("target"), times = n), rep(c("nontarget"), times = n)))
predictor1 = c(scoreNegative1, scorePositive1)
predictor2 = c(scoreNegative2, scorePositive2)
predictor3 = c(scoreNegative3, scorePositive3)
predictors = matrix(c(predictor1, predictor2, predictor3), ncol = 3)
colnames(predictors) = c("DET1", "DET2", "DET3")
detCurves = detc(
  response,
  predictors,
  positive = "target",
  names = colnames(predictors),
  plot = TRUE,
  main = "Example",
  col = c("black", "blue", "red"))

pointsEER(detCurves)
}
