% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_boxplot.r
\name{plot_boxplot}
\alias{plot_boxplot}
\title{Create boxplot for continuous features}
\usage{
plot_boxplot(data, by, title = NULL, ggtheme = theme_gray(),
  theme_config = list(), ...)
}
\arguments{
\item{data}{input data}

\item{by}{feature name to be broken down by. If selecting a continuous feature, boxplot will be grouped by 5 equal ranges, otherwise, all existing categories for a discrete feature.}

\item{title}{plot title}

\item{ggtheme}{complete ggplot2 themes. The default is \link{theme_gray}.}

\item{theme_config}{a list of configurations to be passed to \link{theme}.}

\item{\dots}{other arguments to be passed to \link{geom_boxplot}.}
}
\description{
This function creates boxplot for each continuous feature based on a selected feature.
}
\details{
To change default font family and size, you may pass \code{base_size} and \code{base_family} to \code{ggtheme} options, e.g., \code{ggtheme = theme_gray(base_size = 15, base_family = "serif")}

\code{theme_config} argument expects all inputs to be wrapped in a list object, e.g., to change the text color: \code{theme_config = list("text" = element_text(color = "blue"))}
}
\examples{
# Plot iris dataset by "Species" (discrete)
plot_boxplot(iris, by = "Species")

# Plot mtcars dataset by "mpg" (continuous)
plot_boxplot(mtcars, "mpg")

# Plot with preset ggplot2 themes
library(ggplot2)
plot_boxplot(iris, by = "Species", ggtheme = theme_light())
plot_boxplot(iris, by = "Species", ggtheme = theme_minimal(base_size = 20))

# Plot bar charts with customized theme components
plot_boxplot(iris,
by = "Species",
theme_config = list(
  "plot.background" = element_rect(fill = "yellow"),
  "aspect.ratio" = 1
))
}
\seealso{
\link{geom_boxplot}
}
\keyword{plot_boxplot}
