% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EGA.R
\name{EGA}
\alias{EGA}
\title{Apply the Exploratory Graph Analysis technique}
\usage{
EGA(
  data,
  model = c("glasso", "TMFG"),
  plot.EGA = TRUE,
  n = NULL,
  steps = 4,
  nvar = 4,
  nfact = 1,
  load = 0.7,
  ...
)
}
\arguments{
\item{data}{A dataframe with the variables to be used in the analysis or a correlation matrix.
If the data used is a correlation matrix, the argument \code{n} will need to be specified.}

\item{model}{A string indicating the method to use.
Current options are:

\itemize{

\item{\strong{\code{glasso}}}
{Estimates the Gaussian graphical model using graphical LASSO with
extended Bayesian information criterion to select optimal regularization parameter.
This is the default method}

\item{\strong{\code{TMFG}}}
{Estimates a Triangulated Maximally Filtered Graph}

}}

\item{plot.EGA}{Logical.
If TRUE, returns a plot of the network and its estimated dimensions.
Defaults to TRUE}

\item{n}{Integer.
Sample size, if the data provided is a correlation matrix}

\item{steps}{Number of steps to be used in \code{\link[igraph]{cluster_walktrap}} algorithm.
Defaults to 4.}

\item{nvar}{Number of variables to use in the simulation part of the unidimensionality check. Defaults to 4.}

\item{nfact}{Number of factors to be simulated (part of the unidimensionality check algorithm). Defaults to 1.}

\item{load}{Factor loadings (used in the unidimensionality check algorithm). Defaults to 0.70.}

\item{...}{Additional arguments to be passed to \code{\link{EBICglasso.qgraph}}
or \code{\link[NetworkToolbox]{TMFG}}}
}
\description{
Estimates the number of dimensions of a given dataset/instrument
using graphical lasso (\code{\link{EBICglasso.qgraph}}) or the
Triangulated Maximally Filtered Graph (\code{\link[NetworkToolbox]{TMFG}})
method and the walktrap community detection algorithm (\code{\link[igraph]{cluster_walktrap}}).
The glasso regularization parameter is set via EBIC.
}
\examples{

\donttest{
#estimate EGA
ega.wmt <- EGA(data = wmt2[,7:24], model = "glasso", plot.EGA = TRUE)


#estimate EGAtmfg
ega.wmt <- EGA(data = wmt2[,7:24], model = "TMFG", plot.EGA = TRUE)

#summary statistics
summary(ega.wmt)

#plot
plot(ega.wmt)

#estimate EGA
ega.intel <- EGA(data = intelligenceBattery[,8:66], model = "glasso", plot.EGA = TRUE)

#summary statistics
summary(ega.intel)

#plot
plot(ega.intel)
}
}
\references{
Golino, H. F., & Epskamp, S. (2017).
Exploratory graph analysis: A new approach for estimating the number of dimensions in psychological research.
\emph{PloS one}, \emph{12(6)}, e0174035..
doi: \href{https://doi.org/10.1371/journal.pone.0174035}{journal.pone.0174035}

Golino, H. F., & Demetriou, A. (2017).
Estimating the dimensionality of intelligence like data using Exploratory Graph Analysis.
\emph{Intelligence}, \emph{62}, 54-70.
doi: \href{https://doi.org/10.1016/j.intell.2017.02.007}{j.intell.2017.02.007}

Golino, H., Shi, D., Garrido, L. E., Christensen, A. P., Nieto, M. D., Sadana, R., & Thiyagarajan, J. A. (2018).
Investigating the performance of Exploratory Graph Analysis and traditional techniques to identify the number of latent factors: A simulation and tutorial.
\emph{PsyArXiv}.
doi: \href{https://psyarxiv.com/gzcre/}{10.31234/osf.io/gzcre}
}
\seealso{
\code{\link{bootEGA}} to investigate the stability of EGA's estimation via bootstrap
and \code{\link{CFA}} to verify the fit of the structure suggested by EGA using confirmatory factor analysis.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu>, Alexander P. Christensen <alexpaulchristensen at gmail.com>, Maria Dolores Nieto <acinodam at gmail.com> and Luis E. Garrido <garrido.luiseduardo at gmail.com>
}
