% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilsCollapse.R
\name{collapse-internal}
\alias{collapse-internal}
\alias{qrbind}
\alias{nowarnnum}
\alias{most}
\alias{pairDay}
\alias{mergeAdjacent}
\alias{borrowFreqDoseSeq}
\alias{borrowVal}
\alias{reOrder}
\alias{borrowWithinDoseSeq}
\alias{calcDailyDose}
\alias{daySeqDups}
\alias{rmDuplicates}
\title{Internal functions for collapseDose process}
\description{
These internal functions aid the main functions used in the collapse
process (\code{\link{collapseDose}}, \code{\link{makeDose}}).
}
\details{
\code{qrbind}: fast version of rbind.data.frame

\code{nowarnnum}: converts a variable to numeric and suppresses warnings

\code{most}: returns the mode

\code{pairDay}: calculates daily dose for dose sequences

\code{mergeAdjacent}: collapses adjacent rows that have a drug name change

\code{borrowFreqDoseSeq}: imputes a frequency of 'pm' if the preceding row has a frequency of 'am' or 'noon' and there is a 'pm' elsewhere in the note

\code{borrowVal}: borrow a unique value within a drug mention

\code{reOrder}: order rows

\code{borrowWithinDoseSeq}: borrow values within a dose sequence

\code{calcDailyDose}: calculates daily dose

\code{daySeqDups}: look for duplicate dose sequence 

\code{rmDuplicates}: removes redundant rows
}
\keyword{internal}
