% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ST&P_Rates.R
\name{get_clockrate_table_BEAST2}
\alias{get_clockrate_table_BEAST2}
\title{Extract evolutionary rates from Bayesian clock trees produced by BEAST2}
\usage{
get_clockrate_table_BEAST2(..., summary = "median", drop_dummy = NULL)
}
\arguments{
\item{...}{\code{treedata} objects containing the summary trees with associated data on the rates for each separate clock.}

\item{summary}{summary metric used for the rates. Currently supported: \code{"mean"} or \code{"median"}, default \code{"median"}.}

\item{drop_dummy}{if not \code{NULL}, will drop the dummy extant tip with the given label from the BEAST2 summary trees prior to extracting the clock rates (when present). Default is \code{NULL}.}
}
\value{
A data frame with a column containing the node identifier (\code{node}) and one column containing the clock rates for each tree provided, in the same order as the trees.
}
\description{
BEAST2 stores the rates for each clock in a separate file. All trees need to be loaded using \code{treeio::read.beast}.
}
\examples{
#Import all clock summary trees produced by BEAST2 from your local directory
\dontrun{
tree_clock1 <- treeio::read.beast("tree_file_clock1.tre")
tree_clock2 <- treeio::read.beast("tree_file_clock2.tre")
}

#Or use the example BEAST2 multiple clock trees that accompany EvoPhylo.
data(tree_clock1)
data(tree_clock2)

# obtain the rate table from BEAST2 trees
rate_table <- get_clockrate_table_BEAST2(tree_clock1, tree_clock2, summary = "mean")

}
\seealso{
\code{\link[=get_clockrate_table_MrBayes]{get_clockrate_table_MrBayes()}} for the equivalent function for MrBayes output files.

\code{\link[=clockrate_summary]{clockrate_summary()}} for summarizing and examining properties of the resulting rate table. Note that clade membership for each node must be customized (manually added) before these functions can be used, since this is tree and dataset dependent.
}
