% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FAOsearch.R
\name{FAOsearch}
\alias{FAOsearch}
\title{Search FAOSTAT tables}
\usage{
FAOsearch(
  code = NULL,
  dataset = NULL,
  topic = NULL,
  latest = FALSE,
  full = TRUE
)
}
\arguments{
\item{code}{character code of the dataset, listed as DatasetCode}

\item{dataset}{character name of the dataset (or part of the name), listed as DatasetName in the output data frame}

\item{topic}{character topic from list}

\item{latest}{boolean sort list by latest updates}

\item{full}{boolean, TRUE returns the full table with all columns}
}
\description{
Get full list of datasets from the FAOSTAT database with the Code, Dataset Name and Topic.
}
\examples{
\dontrun{
# Find information about all datasets
fao_metadata <- FAOsearch()    
# Find information about the forestry dataset
FAOsearch(code="FO")
# Find information about datasets whose titles contain the word "Flows"
FAOsearch(dataset="Flows", full = FALSE)
}
}
