% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage.R
\name{annual_coverage}
\alias{annual_coverage}
\title{Calculate Annual Coverage}
\usage{
annual_coverage(x)
}
\arguments{
\item{x}{Object of class \code{ghcn_daily}. See \code{\link[=daily]{daily()}} for details.}
}
\value{
A table with annual coverage.
}
\description{
\code{annual_coverage()} calculates how many days have been recorded for
each year in the time period.
}
\details{
To calculate the coverage, a full daily time range is full joined to the
timeseries. Missing days are set to NA. Coverage is then calculated as
the number of values that are not NAs over the number of NAs.
}
\examples{
cleaned <- remove_flagged(CA003076680)
cover <- annual_coverage(cleaned)
cover
}
