% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLMcatMethods.R
\name{extractAIC.glmcat}
\alias{extractAIC.glmcat}
\title{Extract AIC from a fitted \code{glmcat} model object}
\usage{
\method{extractAIC}{glmcat}(fit, ...)
}
\arguments{
\item{fit}{an fitted object of class \code{glmcat}.}

\item{...}{further arguments (currently unused in base R).}
}
\description{
Method to compute the (generalized) Akaike An Information Criterion for a fitted object of class \code{glmcat}.
}
\examples{
model <- glmcat(formula = Level ~ Age, data = DisturbedDreams,
                ref_category = "Very.severe", ratio = "cumulative")
extractAIC(model)
}
