% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allgotree.R
\name{GetLeafNodesCC}
\alias{GetLeafNodesCC}
\title{All the CC GO-DAG leaf nodes}
\usage{
GetLeafNodesCC(organism = NULL)
}
\arguments{
\item{organism}{An object of class character that represents an organism}
}
\value{
A two-coloum matrix of all leaf nodes in the organism-specific DAG and their respective levels
}
\description{
Returns all the leaf nodes from a particular organism-specific GO-DAG. If empty (or if "CC"),
             all the general CC GO-DAG leaf nodes are returned. The supported organism are "Homo sapiens / Human",
             "Rattus norvegicus / Rat", "Mus musculus / Mouse", "Danio rerio / Zebrafish", "Caenorhabditis elegans / Worm",
             "Arabidopsis thaliana / Cress", "Saccharomyces cerevisiae / Yeast", "Schizosaccharomyces pombe / Fission yeast",
             "Drosophila melanogaster / Fruit fly", "Escherichia coli / E.coli".
}
\examples{
\donttest{
# Zebrafish CC GO-DAG leaf nodes
 GetLeafNodesCC("Danio rerio")

# Mouse CC GO-DAG leaf nodes
GetLeafNodesCC("Mouse")

}
}
