% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HGDMr-package.R
\docType{package}
\name{HGDMr-package}
\alias{HGDMr}
\alias{HGDMr-package}
\title{The Hysteretic and Gatekeeping Depressions Model (HGDM)}
\description{
\pkg{HGDMr} is an implementation of the Hysteretic and Gatekeeping 
Depressions Model (HGDM) which is a one-dimensional model of the effects of
varying connected/contributing fractions of Canadian Prairie basins.

Using specified fluxes (rainfall, snowmelt, upland runoff and evaporation), HGDM
computes a) the time-varying connected/contributing fraction of a basin having
depressional storage and b) the depth of discharge in each time interval.

Note that this model does not route the flows through the basin. This would require
the use of another \R package, such as \pkg{RHMS}, which has the function `reachRouting`.
}
\references{
Shook, Kevin R., and John W. Pomeroy. “The Hysteretic and Gatekeeping Depressions Model - A New Model for Variable Connected Fractions of Prairie Basins.” Journal of Hydrology 654 (June 1, 2025): 132821. https://doi.org/10.1016/j.jhydrol.2025.132821.

Shook, Kevin R., Zhihua He, John W. Pomeroy, Chris Spence, and Colin J. Whitfield. “A Practitioner-Oriented Regional Hydrology Data Product for Use in Site-Specific Hydraulic Applications.” Scientific Data 11, no. 1 (October 14, 2024): 1125. https://doi.org/10.1038/s41597-024-03962-1.

Clark, Martyn P., and Kevin R. Shook. “The Numerical Formulation of Simple Hysteretic Models to Simulate the Large-Scale Hydrological Impacts of Prairie Depressions.” Water Resources Research 58, no. 12 (2022): e2022WR032694. https://doi.org/10.1029/2022WR032694.

Shook, Kevin, Simon Papalexiou, and John W. Pomeroy. “Quantifying the Effects of Prairie Depressional Storage Complexes on Drainage Basin Connectivity.” Journal of Hydrology 593 (February 1, 2021): 125846. https://doi.org/10.1016/j.jhydrol.2020.125846.

Shook, Kevin, John W Pomeroy, Christopher Spence, and Lyle Boychuk. “Storage Dynamics Simulations in Prairie Wetland Hydrology Models: Evaluation and Parameterization.” Hydrological Processes 27, no. 13 (June 2013): 1875–89. https://doi.org/10.1002/hyp.9867.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/CentreForHydrology/HGDMr}
}

}
\author{
\strong{Maintainer}: Kevin Shook \email{kevin.shook@usask.ca}

}
\keyword{package}
