% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_HeadwaterSubids.R
\name{HeadwaterSubids}
\alias{HeadwaterSubids}
\title{Find all headwater SUBIDs of a model domain}
\usage{
HeadwaterSubids(gd)
}
\arguments{
\item{gd}{A data frame, containing among others two columns \code{subid} and \code{maindown}. Column names are not case-sensitive
and column positions in the data frame are irrelevant.
Typically a 'GeoData.txt' file imported using \code{\link{ReadGeoData}}.}
}
\value{
\code{HeadwaterSubids} returns a vector of outlet SUBIDs.
}
\description{
Function to find all headwater SUBIDs of a HYPE model domain.
}
\details{
\code{HeadwaterSubids} finds all headwater SUBIDs of a model domain as provided in a 'GeoData.txt' file, i.e. all subcatchments
which do not have any upstream subcatchments.
}
\examples{
te <- ReadGeoData(filename = system.file("demo_model", "GeoData.txt", package = "HYPEtools"))
HeadwaterSubids(gd = te)

}
\seealso{
\code{\link{AllUpstreamSubids}}
}
