% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGradient.R
\name{plotGradient}
\alias{plotGradient}
\title{plotGradient}
\usage{
plotGradient(
  hM,
  Gradient,
  predY,
  measure,
  xlabel = NULL,
  ylabel = NULL,
  index = 1,
  q = c(0.025, 0.5, 0.975),
  cicol = rgb(0, 0, 1, alpha = 0.5),
  pointcol = "lightgrey",
  pointsize = 1,
  showData = FALSE,
  jigger = 0,
  yshow = NA,
  showPosteriorSupport = TRUE,
  main,
  ...
)
}
\arguments{
\item{hM}{a fitted \code{Hmsc} model object}

\item{Gradient}{an object returned by \code{\link{constructGradient}}}

\item{predY}{an object returned by applying the function \code{\link{predict}} to \code{Gradient}}

\item{measure}{whether to plot species richness ("S"), an individual species ("Y") or community-weighted
mean trait values ("T")}

\item{xlabel}{label for x-axis}

\item{ylabel}{label for y-axis}

\item{index}{which species or trait to plot}

\item{q}{quantiles of the credibility interval plotted}

\item{cicol}{colour with which the credibility interval is plotted}

\item{pointcol}{colour with which the data points are plotted}

\item{pointsize}{size in which the data points are plotted}

\item{showData}{whether raw data are plotted as well}

\item{jigger}{the amount by which the raw data are to be jiggered in x-direction (for factors) or
y-direction (for continuous covariates)}

\item{yshow}{scale y-axis so that these values are also
visible. This can used to scale y-axis so that it includes 0
and the expected maximum values.}

\item{showPosteriorSupport}{add margin text on the posterior
support of predicted change from gradient minimum to maximum
for continuous gradients.}

\item{main}{main title for the plot.}

\item{...}{additional arguments for plot}
}
\value{
For the case of a continuous covariate, returns the posterior probability that the plotted
variable is greater for the last sampling unit of the gradient than for the first sampling unit of
the gradient. For the case of a factor, returns the plot object.
}
\description{
Plots an environmental gradient over one of the variables included in \code{XData}
}
\details{
For \code{measure}="Y", \code{index} selects which species to plot from \code{hM$spNames}.
For \code{measure}="T", \code{index} selects which trait to plot from \code{hM$trNames}.
With \code{measure}="S" the row sum of \code{pred} is plotted,
and thus the interpretation of "species richness" holds only for probit models.
For Poisson models "S" shows the total count,
whereas for normal models it shows the summed response.
For \code{measure}="T",
in probit model the weighting is over species occurrences,
whereas in count models it is over individuals.
In normal models, the weights are exp-transformed predictions to avoid negative weights
}
\examples{
# Plot response of species 2 over the gradient of environmental variable x1
Gradient = constructGradient(TD$m, focalVariable="x1")
predY = predict(TD$m, Gradient=Gradient)
plotGradient(TD$m, Gradient, pred=predY, measure="Y", index = 2, showData = TRUE, jigger = 0.05)
# Plot modelled species richness over the gradient of environmental variable x1
Gradient = constructGradient(TD$m, focalVariable="x1")
predY = predict(TD$m, Gradient=Gradient)
plotGradient(TD$m, Gradient, pred=predY, measure="S")

}
\seealso{
\code{\link{constructGradient}}, \code{\link{predict}}
}
