% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_manual_process.R
\name{input_manual_process}
\alias{input_manual_process}
\title{Input Manual Process}
\usage{
input_manual_process(data)
}
\arguments{
\item{data}{list generated by \code{\link{input_manual_simple}} or
\code{\link{input_manual_nested}} with complete data.}
}
\value{
List containing formatted data including center distances for
 \code{\link{item_chart}}, \code{\link{facet_chart}}, and
 \code{\link{nested_chart}}.
}
\description{
Pre-processes the SEM estimates listed using \code{\link{input_manual_simple}}
or \code{\link{input_manual_nested}} for the use of chart functions.
}
\examples{
# these RSES data can also be seen in self_confidence, the example data of
# this package
mydata <- input_manual_simple(
test_name = "RSES",
facet_names = c("Ns", "Ps"),
items_per_facet = 5,
item_names = c(2, 5, 6, 8, 9,
              1, 3, 4, 7, 10),
test_loadings = c(.5806, .5907, .6179, .5899, .6559,
                    .6005, .4932, .4476, .5033, .6431),
facet_loadings = c(.6484, .6011, .6988, .6426, .6914,
                       .6422, .5835, .536, .5836, .6791),
correlation_matrix = matrix(data = c(1, .69,
                                    .69, 1),
                           nrow = 2,
                           ncol = 2))
mydata
input_manual_process(mydata)

}
\seealso{
\code{\link{input_manual_simple}} \code{\link{input_manual_nested}}
}
