% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator.R
\name{quantityIndicator}
\alias{quantityIndicator}
\title{Compute a quantity indicator}
\usage{
quantityIndicator(x, pvar, qvar, pervar, prodID, method, sample = "matched")
}
\arguments{
\item{x}{data frame with input data}

\item{pvar}{character string for the name of the price column}

\item{qvar}{character string for the name of the quantity column}

\item{pervar}{character string for the name of the time period variable}

\item{prodID}{character string for the name of the product ID column}

\item{method}{character string for the quantity indicator method. Valid options
are "laspeyres", "paasche", "bennet", or "montgomery".}

\item{sample}{whether to use a matched sample (sample = "matched")}
}
\value{
an nx1 matrix containing the indicator
}
\description{
This calculates a quantity indicator. This is calculated using the
differences approach to index number theory, where the change
in prices and quantities from one period to the next is additive.
Therefore, the change in total value is the sum of the change
in prices and the change in quantities. Such a value decomposition
can be obtained using \code{valueDecomposition}.

See the vignette for more information on the calculations.

\code{vignette(topic = "indexnumr", package = "IndexNumR")}
}
\examples{
# compute a quantity indicator using the Bennet method
quantityIndicator(CES_sigma_2, pvar = "prices", qvar = "quantities",
prodID = "prodID", pervar = "time", method = "bennet")
}
