% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScoreFormulaCombination.R
\name{ScoreFormulaCombination}
\alias{ScoreFormulaCombination}
\title{ScoreFormulaCombination.}
\usage{
ScoreFormulaCombination(rdisop_res, nl_vec = c(C1H4 = 16.0313),
  punish_nas = 0.8, punish_invalid = 0.5, punish_S = 0.2,
  punish_Cl = 0.2, punish_nonplausible = 0.2, return_rank = 1,
  neutral_loss_cutoff = 0.5, substitutions = substitutions, silent = TRUE)
}
\arguments{
\item{rdisop_res}{Internal result structure of InterpretMSSpectrum.}

\item{nl_vec}{Named vector of neutral losses or NULL.}

\item{punish_nas}{For each unexplained fragment in the tree the overall score will be multiplied by this value as a penalty.}

\item{punish_invalid}{Lower formulas tagged invalid by Rdisop by factor 1-punish_invalid, e.g. punish_invalid=0.5 would lower a score of 80 to 40.}

\item{punish_S}{Lower formulas containing Sufor by factor 1-punish_S*n_S, e.g. punish_S=0.2 would lower a score of 100 to 60 if 2 Sulfor are contained.}

\item{punish_Cl}{Lower formulas containing Chlor by factor 1-punish_Cl*n_Cl, e.g. punish_Cl=0.2 would lower a score of 100 to 80 if 1 Chlor is contained.}

\item{punish_nonplausible}{Check for all potential fragments not only if they are a subformula but if this neutral loss is a plausible formula itself and lower according to}

\item{return_rank}{Integer, will return the n-th best combination; if NA will return a ranked list of all found combinations.}

\item{neutral_loss_cutoff}{Cutoff in mDa for accepting an internal mass difference as a given neutral loss.}

\item{silent}{Print some stats or not.}
}
\value{
Output will be the most likely combination of fragments by evaluating the largest mean score combination of all fragments.
}
\description{
\code{ScoreFormulaCombination} takes a rdisop formula seach result as a list. This list will contain formula suggestions for certain masses (including Score information) and masses should be in ascending order.
}
\details{
Not exported.
}
\keyword{internal}
