% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KbSkewness.R
\name{pcKbSkew}
\alias{pcKbSkew}
\title{Principal-component-based Khattree-Bahuguna's Multivariate Skewness}
\usage{
pcKbSkew(x, cor = FALSE)
}
\arguments{
\item{x}{a matrix of original scale observations.}

\item{cor}{a logical value indicating whether the calculation should use the correlation matrix (\code{cor = TRUE}) or the covariance matrix (\code{cor = FALSE}). The default value is \code{cor = FALSE}.}
}
\value{
\code{pcKbSkew} gives the sample principal-component-based Khattree-Bahuguna's multivairate skewness.
}
\description{
Compute Principal-component-based Khattree-Bahuguna's Multivariate Skewness.
}
\details{
Let \eqn{\mathbf{X} = X_1, \ldots, X_p} be a \eqn{p}-dimensional multivariate random vector. We compute the sample skewness for \eqn{p} principal components of \eqn{\mathbf{X}} respectively by the sample Khattree-Bahuguna's univariate skewness formula (see details of \code{\link{kbSkew}} that follows). Let \eqn{\eta_1, \eta_2, \ldots, \eta_p} be the \eqn{p} univariate skewnesses for \eqn{p} principal components. Principal-component-based Khattree-Bahuguna's multivariate skewness for a sample is then defined as
\deqn{\eta = \sum_{i=1}^{p} \eta_i.}
}
\examples{
# Compute principal-component-based Khattree-Bahuguna's multivairate skewness

data(OlymWomen)
pcKbSkew(OlymWomen[, c("m800","m1500","m3000","marathon")])

}
\references{
Khattree, R. and Bahuguna, M. (2019). An alternative data analytic approach to measure the univariate and multivariate skewness. \emph{International Journal of Data Science and Analytics}, Vol. 7, No. 1, 1-16.
}
\seealso{
\code{\link{kbSkew}} for Khattree-Bahuguna's univariate skewness.
}
