% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kraljic-matrix-functions.R
\name{kraljic_matrix}
\alias{kraljic_matrix}
\title{Kraljic matrix plotting function}
\usage{
kraljic_matrix(data, x, y)
}
\arguments{
\item{data}{A data frame}

\item{x}{Numeric vector of values}

\item{y}{Numeric vector of values with compatible dimensions to \code{x}}
}
\value{
A Kraljic purchasing matrix plot
}
\description{
\code{kraljic_matrix} plots each product or service in the Kraljic purchasing
matrix based on the attribute value score of \code{x} and \code{y}
}
\examples{

# Given the following \\code{x} and \\code{y} attribute values we can plot each
# product or service in the purchasing matrix:

# to add a new variable while preserving existing data
library(dplyr)

psc2 <- psc \%>\%
  mutate(x_SAVF_score = SAVF_score(x_attribute, 1, 5, .653),
         y_SAVF_score = SAVF_score(y_attribute, 1, 10, .7))

kraljic_matrix(psc2, x_SAVF_score, y_SAVF_score)

}
\seealso{
\code{\link{SAVF_score}} for computing the exponential single attribute value
score for \code{x} and \code{y}
}

