% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overwrite_functions.R
\name{print.LBBNN_Net}
\alias{print.LBBNN_Net}
\title{Print summary of an \code{LBBNN_Net} object}
\usage{
\method{print}{LBBNN_Net}(x, ...)
}
\arguments{
\item{x}{An object of class \code{LBBNN_Net}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Invisibly returns the input \code{x}.
}
\description{
Provides a summary of a trained \code{LBBNN_Net} object.
Includes the model type (input-skip or not), whether normalizing flows
are used, module and sub-module structure, number of trainable parameters, and prior
variance and inclusion probabilities for the weights.
}
\examples{
\donttest{ 
x<-torch::torch_randn(3,2) 
b <- torch::torch_rand(2)
y <- torch::torch_matmul(x,b)
train_data <- torch::tensor_dataset(x,y)
train_loader <- torch::dataloader(train_data,batch_size = 3,shuffle=FALSE)
problem<-'regression'
sizes <- c(2,1,1) 
inclusion_priors <-c(0.9,0.2) 
inclusion_inits <- matrix(rep(c(-10,10),2),nrow = 2,ncol = 2)
stds <- c(1.0,1.0)
model <- LBBNN_Net(problem,sizes,inclusion_priors,stds,inclusion_inits,flow = FALSE,
input_skip = TRUE)
print(model)
}
}
