% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replicate_delete.R
\name{replicate.delete}
\alias{replicate.delete}
\title{Delete repeated channel data generated by LC-MS}
\usage{
replicate.delete(data, delete.pattern = c("_\\\\d", "(\\\\+)AcO"))
}
\arguments{
\item{data}{Primary lipidomic data in .csv  format.}

\item{delete.pattern}{Pattern of characters that needs to be removed.}
}
\value{
Edited data with no repeat channels and simplified row name.
}
\description{
replicate.delete select one of the channel with largest mean value out of multiple replicated LC-MS cahnnels,
   and it returns an edited data frame with no repeated channel and simplified row name.
}
\examples{
x1 <- c(1,1,1,1)
x2 <- c(1.1,1.2,1.3,1.4)
x3 <- c(1,1,1,1)
x4 <- c(2,2,2,2)
rowNames <- c('PC(14:0/14:1)+AcO_1','PC(14:0/14:1)+AcO_2','PC(16:0/16:1)_1','PC(16:0/16:1)_2')
ExampleData <- data.frame(x1,x2,x3,x4, row.names =rowNames)
replicate.delete(ExampleData,delete.pattern= c('_\\\\d','(\\\\+)AcO'))
}
