% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcee_helper_nuisance_config.R
\name{mcee_config_ranger}
\alias{mcee_config_ranger}
\title{Configure Ranger Random Forest for MCEE nuisance parameters}
\usage{
mcee_config_ranger(target, formula)
}
\arguments{
\item{target}{Character. Nuisance parameter name ("p", "q", "eta", "mu", "nu").}

\item{formula}{RHS-only formula (e.g., \code{~ X1 + X2 + dp}).}
}
\value{
A configuration list for use with \code{\link{mcee_general}}.
}
\description{
Creates a configuration to fit nuisance parameters using ranger random forests
via \code{ranger::ranger()}. Faster alternative to \code{randomForest}.
}
\examples{
# Ranger random forest for outcome model
cfg_eta <- mcee_config_ranger("eta", ~ dp + X1 + X2 + X3)
}
