% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertWBDHUC.R
\name{convertWBDHUC}
\alias{convertWBDHUC}
\title{Convert USGS hydrologic unit geodatabase}
\usage{
convertWBDHUC(
  gdbDir = "~/Data/WBD/WBD_National_GDB.gdb",
  level = 2,
  simplify = TRUE
)
}
\arguments{
\item{gdbDir}{Directory containing the geodatabase.}

\item{level}{Character or integer which must be 2, 4, 6, 8, 10, 12 or 14.}

\item{simplify}{Logical specifying whether to perform simplification}
}
\value{
Name of the datasetName being created.
}
\description{
Create a simple features data frame for USGS watershed boundaries
}
\details{
A USGS Watershed Boundary Dataset geodatabase is converted to a
simple features data frame with additional columns of data. To use this
function, the WBD geodatabase must be downloaded into a directory which is
identified with \code{gdbDir}. The resulting file will be created in the
spatial data directory which is set with \code{setSpatialDataDir()}.

The full WBD datasetName can be downloaded from the USGS with the
following command:
\preformatted{
curl https://prd-tnm.s3.amazonaws.com/StagedProducts/Hydrography/WBD/National/GDB/WBD_National_GDB.zip -O
}

The source data was downloaded on 2023-03-23.
}
\note{
From the source documentation:

The Watershed Boundary Dataset (WBD) is a comprehensive aggregated collection
of hydrologic unit data consistent with the national criteria for delineation
and resolution. It defines the areal extent of surface water drainage to a
point except in coastal or lake front areas where there could be multiple
outlets as stated by the &quot;Federal Standards and Procedures for the
National Watershed Boundary Dataset (WBD)&quot; &quot;Standard&quot;
(https://pubs.usgs.gov/tm/11/a3/). Watershed boundaries are determined solely
upon science-based hydrologic principles, not favoring any administrative
boundaries or special projects, nor particular program or agency. This dataset
represents the hydrologic unit boundaries to the 12-digit (6th level) for the
entire United States. Some areas may also include additional subdivisions
representing the 14- and 16-digit hydrologic unit (HU). At a minimum, the HUs
are delineated at 1:24,000-scale in the conterminous United States,
1:25,000-scale in Hawaii, Pacific basin and the Caribbean, and 1:63,360-scale
in Alaska, meeting the National Map Accuracy Standards (NMAS). Higher
resolution boundaries are being developed where partners and data exist and
will be incorporated back into the WBD. WBD data are delivered as a dataset
of polygons and corresponding lines that define the boundary of the polygon.
WBD polygon attributes include hydrologic unit codes (HUC), size (in the form
of acres and square kilometers), name, downstream hydrologic unit code, type
of watershed, non-contributing areas, and flow modifications. The HUC
describes where the unit is in the country and the level of the unit. WBD
line attributes contain the highest level of hydrologic unit for each boundary,
line source information and flow modifications.

The intent of defining Hydrologic Units (HU) within the Watershed Boundary
Dataset is to establish a base-line drainage boundary framework, accounting
for all land and surface areas. Hydrologic units are intended to be used as
a tool for water-resource management and planning activities particularly
for site-specific and localized studies requiring a level of detail provided
by large-scale map information. The WBD complements the National Hydrography
Dataset (NHD) and supports numerous programmatic missions and activities
including: watershed management, rehabilitation and enhancement, aquatic
species conservation strategies, flood plain management and flood prevention,
water-quality initiatives and programs, dam safety programs, fire assessment
and management, resource inventory and assessment, water data analysis and
water census.
}
\references{
\url{https://www.usgs.gov/national-hydrography/watershed-boundary-dataset}
}
\seealso{
setSpatialDataDir
}
\keyword{datagen}
