% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{stations_sinaica_df}
\alias{stations_sinaica_df}
\title{Air Quality Measuring Stations in Mexico (SINAICA)}
\format{
A data frame with 365 observations and 26 variables:
\describe{
  \item{station_id}{Station identifier (integer)}
  \item{station_name}{Name of the station (character)}
  \item{station_code}{Code of the station (character)}
  \item{network_id}{Identifier of the network (integer)}
  \item{network_name}{Name of the network (character)}
  \item{network_code}{Code of the network (character)}
  \item{street}{Street address (character)}
  \item{ext}{External number (character)}
  \item{interior}{Interior number (character)}
  \item{colonia}{Colonia (neighborhood) name (character)}
  \item{zip}{Postal code (character)}
  \item{state_code}{State code (integer)}
  \item{municipio_code}{Municipality code (integer)}
  \item{year_started}{Year the station began operation (integer)}
  \item{altitude}{Altitude of the station in meters (integer)}
  \item{address}{Full address of the station (character)}
  \item{date_validated}{Validation date (character)}
  \item{date_validated2}{Second validation date (character)}
  \item{passed_validation}{Indicates if the station passed validation (integer)}
  \item{video}{Video URL or link (character)}
  \item{lat}{Latitude (numeric)}
  \item{lon}{Longitude (numeric)}
  \item{date_started}{Date the station started operation (character)}
  \item{timezone}{Timezone of the station (character)}
  \item{street_view}{Street view URL or link (character)}
  \item{video_interior}{Interior video URL or link (character)}
}
}
\source{
Data taken from the rsinaica package version 1.1.0
}
\usage{
data(stations_sinaica_df)
}
\description{
This dataset, stations_sinaica_df, is a data frame containing information about air quality monitoring
stations that report to the National Air Quality Information System (SINAICA) in Mexico.
The dataset includes 365 observations and 26 variables, providing metadata on station identifiers,
geolocation, network affiliations, operational status, and other attributes such as video links and validation dates.
}
\details{
The dataset name has been kept as 'stations_sinaica_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
MexicoDataAPI package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
