% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{postcluster_pq}
\alias{postcluster_pq}
\alias{asv2otu}
\title{Recluster sequences of an object of class \code{physeq}
or a list of DNA sequences}
\usage{
postcluster_pq(
  physeq = NULL,
  dna_seq = NULL,
  nproc = 1,
  method = "clusterize",
  id = 0.97,
  vsearchpath = "vsearch",
  tax_adjust = 0,
  vsearch_cluster_method = "--cluster_size",
  vsearch_args = "--strand both",
  keep_temporary_files = FALSE,
  swarmpath = "swarm",
  d = 1,
  swarm_args = "--fastidious",
  method_clusterize = "overlap",
  ...
)

asv2otu(
  physeq = NULL,
  dna_seq = NULL,
  nproc = 1,
  method = "clusterize",
  id = 0.97,
  vsearchpath = "vsearch",
  tax_adjust = 0,
  vsearch_cluster_method = "--cluster_size",
  vsearch_args = "--strand both",
  keep_temporary_files = FALSE,
  swarmpath = "swarm",
  d = 1,
  swarm_args = "--fastidious",
  method_clusterize = "overlap",
  ...
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{dna_seq}{You may directly use a character vector of DNA sequences
in place of physeq args. When physeq is set, dna sequences take the value of
\code{physeq@refseq}}

\item{nproc}{(default: 1)
Set to number of cpus/processors to use for the clustering}

\item{method}{(default: clusterize)
Set the clustering method.
\itemize{
\item \code{clusterize} use the \code{\link[DECIPHER:Clusterize]{DECIPHER::Clusterize()}} fonction,
\item \code{vsearch} use the vsearch software (https://github.com/torognes/vsearch)
with arguments \code{--cluster_size} by default (see args \code{vsearch_cluster_method})
and \verb{-strand both} (see args \code{vsearch_args})
\item \code{swarm} use the swarm
}}

\item{id}{(default: 0.97) level of identity to cluster}

\item{vsearchpath}{(default: vsearch) path to vsearch}

\item{tax_adjust}{(Default 0) See the man page
of \code{\link[=merge_taxa_vec]{merge_taxa_vec()}} for more details.
To conserved the taxonomic rank of the most abundant taxa (ASV, OTU,...),
set tax_adjust to 0 (default). For the moment only tax_adjust = 0 is
robust}

\item{vsearch_cluster_method}{(default: "--cluster_size) See other possible
methods in the \href{https://github.com/torognes/vsearch/}{vsearch manual} (e.g. \code{--cluster_size} or \code{--cluster_smallmem})
\itemize{
\item \code{--cluster_fast} : Clusterize the fasta sequences in filename, automatically sort by decreasing sequence length beforehand.
\item \code{--cluster_size} : Clusterize the fasta sequences in filename, automatically sort by decreasing sequence abundance beforehand.
\item \code{--cluster_smallmem} : Clusterize the fasta sequences in filename without automatically modifying their order beforehand. Sequence are expected to be sorted by decreasing sequence length, unless \emph{--usersort} is used.
In that case you may set \code{vsearch_args} to vsearch_args = "--strand both --usersort"
}}

\item{vsearch_args}{(default : "--strand both") a one length character element defining other parameters to
passed on to vsearch.}

\item{keep_temporary_files}{(logical, default: FALSE) Do we keep temporary files
\itemize{
\item temp.fasta (refseq in fasta or dna_seq sequences)
\item cluster.fasta (centroid if method = "vsearch")
\item temp.uc (clusters if method = "vsearch")
}}

\item{swarmpath}{(default: swarm) path to swarm}

\item{d}{(default: 1) maximum number of differences allowed between two
amplicons, meaning that two amplicons will be grouped if they have \code{d}
(or less) differences}

\item{swarm_args}{(default : "--fastidious") a one length character
element defining other parameters to  passed on to swarm See other possible
methods in the \href{https://github.com/torognes/swarm/blob/master/man/swarm_manual.pdf}{SWARM pdf manual}}

\item{method_clusterize}{(default "overlap") the method for the \code{\link[DECIPHER:Clusterize]{DECIPHER::Clusterize()}} method}

\item{...}{Additional arguments passed on to \code{\link[DECIPHER:Clusterize]{DECIPHER::Clusterize()}}}
}
\value{
A new object of class \code{physeq} or a list of cluster if dna_seq
args was used.
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-maturing-blue" alt="lifecycle-maturing"></a>
}}


This function use the \code{merge_taxa_vec} function to  merge taxa into clusters.
}
\details{
This function use the \code{merge_taxa_vec} function to
merge taxa into clusters. By default tax_adjust = 0. See the man page
of \code{\link[=merge_taxa_vec]{merge_taxa_vec()}}.
}
\examples{
if (requireNamespace("DECIPHER")) {
  postcluster_pq(data_fungi_mini)
}
\donttest{
if (requireNamespace("DECIPHER")) {
  postcluster_pq(data_fungi_mini, method_clusterize = "longest")

  if (MiscMetabar::is_swarm_installed()) {
    d_swarm <- postcluster_pq(data_fungi_mini, method = "swarm")
  }
  if (MiscMetabar::is_vsearch_installed()) {
    d_vs <- postcluster_pq(data_fungi_mini, method = "vsearch")
  }
}
}
}
\references{
VSEARCH can be downloaded from
\url{https://github.com/torognes/vsearch}.
More information in the associated publication
\url{https://pubmed.ncbi.nlm.nih.gov/27781170}.
}
\seealso{
\code{\link[=vsearch_clustering]{vsearch_clustering()}} and \code{\link[=swarm_clustering]{swarm_clustering()}}
}
\author{
Adrien Taudière
}
