% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.genotyped.snp.R
\name{get.genotyped.snp}
\alias{get.genotyped.snp}
\title{Derive which markers are genotyped of selected individuals}
\usage{
get.genotyped.snp(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  export.alleles = FALSE,
  use.id = FALSE
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{export.alleles}{If TRUE export underlying alleles instead of just 012}

\item{use.id}{Set to TRUE to use MoBPS ids instead of Sex_Nr_Gen based names (default: FALSE)}
}
\value{
Binary Coded is/isnot genotyped level for in gen/database/cohorts selected individuals
}
\description{
Function to devide which markers are genotyped for the selected individuals
}
\examples{
data(ex_pop)
genotyped.snps <- get.genotyped.snp(ex_pop, gen=2)
}
