% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{data_event}
\alias{data_event}
\title{Matchs de football joués en France de 2011/2012 à 2016/2017}
\format{
Un objet \code{data.frame} avec 208446 lignes et 40 variables :
\describe{
  \item{\code{X}}{Integer vector, identifiant unique de ligne}
  \item{\code{id_odsp}}{Factor w/ 2076 levels, identifiant unique de match}
  \item{\code{id_event}}{Factor w/ 208446, unique identifier of event (id_odsp + sort_order)}
  \item{\code{sort_order}}{Integer vector, chronological sequence of events in a game}
  \item{\code{time}}{Integer vector, minute of the game}
  \item{\code{text}}{Factor w/ 79629 levels, text commentary}
  \item{\code{event_type}}{Integer vector, primary event. 11 unique events (1-Attempt(shot), 2-Corner, 3-Foul, 4-Yellow Card, 5-Second yellow card, 6-(Straight) red card, 7-Substitution, 8-Free kick won, 9-Offside, 10-Hand Ball, 11-Penalty conceded)}
  \item{\code{event_type2}}{Integer vector, secondary event. 4 unique events (12 - Key Pass, 13 - Failed through ball, 14-Sending off, 15-Own goal)}
  \item{\code{side}}{Integer vector, 1-Home, 2-Away}
  \item{\code{event_team}}{Factor w/ 30 levels, Équipe de football qui est à l’origine de l’événement. In case of Own goals, event team is the team that beneficiated from the own goal}
  \item{\code{opponent}}{Factor w/ 30 levels, team that the event happened against}
  \item{\code{player}}{Factor w/ 1609, name of the player involved in main event (converted to lowercase and special chars were removed)}
  \item{\code{player2}}{Factor w/ 1498, name of player involved in secondary event}
  \item{\code{player_in}}{Factor w/ 1277, player that came in (only applies to substitutions)}
  \item{\code{player_out}}{Factor w/ 1204, player substituted (only applies to substitutions)}
  \item{\code{shot_place}}{Integer vector, placement of the shot (13 possible placement locations, available in the dictionary, only applies to shots)}
  \item{\code{shot_outcome}}{Integer vector, 4 possible outcomes (1-On target, 2-Off target, 3-Blocked, 4-Hit the post)}
  \item{\code{is_goal}}{Integer vector, binary variable if the shot resulted in a goal (own goals included)}
  \item{\code{location}}{Integer vector, location on the pitch where the event happened (19 possible locations, available in the dictionary)}
  \item{\code{bodypart}}{Integer vector, (1- right foot, 2-left foot, 3-head)}
  \item{\code{assist_method}}{Integer vector, in case of an assisted shot, 5 possible assist methods (details in the dictionary)}
  \item{\code{situation}}{Integer vector, 4 types: 1-Open Play, 2-Set piece (excluding Direct Free kicks), 3-Corner, 4-Free kick}
  \item{\code{fast_break}}{Integer vector, binary}
  \item{\code{link_odsp}}{Factor w/ 2076 levels lien vers la page oddsportal}
  \item{\code{adv_stats}}{Logical vector, boolean if the game has detailed event data}
  \item{\code{date}}{Factor w/ 592 levels, Date of game}
  \item{\code{league}}{Factor w/ 1 level, Club League}
  \item{\code{season}}{Integer vector, Year Played}
  \item{\code{country}}{Factor w/ 1 level, Host Nation of League}
  \item{\code{ht}}{Factor w/ 30 levels, home team}
  \item{\code{at}}{Factor w/ 30 levels, away team}
  \item{\code{fthg}}{Integer vector, full time home goals}
  \item{\code{ftag}}{Integer vector, full time away goals}
  \item{\code{odd_h}}{Numerical vector, highest home win market odds}
  \item{\code{odd_d}}{Numerical vector, highest draw market odds}
  \item{\code{odd_a}}{Numerical vector, highest away market odds}
  \item{\code{odd_over}}{Numerical vector, highest over 2.5 market odds}
  \item{\code{odd_under}}{Numerical vector, highest under 2.5 market odds}
  \item{\code{odd_bts}}{Numerical vector, highest both teams to score market odds}
  \item{\code{odd_bts_n}}{Numerical vector, highest both teams NOT to score market odds} 
}
}
\source{
Kaggle.
}
\usage{
data_event
}
\description{
Ce fichier de données fournit une vue granulaire de 208 446 matchs de football joués en France depuis la saison 2011/2012 à la saison 2016/2017.
}
\details{
Ces données sont une version « nettoyée » d’un fichier original, events_France.csv, qu’il est possible de télécharger depuis la plate-forme Kaggle : \url{https://www.kaggle.com/secareanualin/football-events}.
Certains matchs contiennent cependant des données manquantes (environ 10%).
}
\keyword{datasets}
