% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GraphicalOutputs.R
\name{FEVDandGFEVDgraphs}
\alias{FEVDandGFEVDgraphs}
\title{FEVD and GFEVD graphs for all models}
\usage{
FEVDandGFEVDgraphs(
  ModelType,
  NumOut,
  WishPdynamicsgraphs,
  WishYieldsgraphs,
  FEVDhoriz,
  PathsGraphs,
  OutputType,
  Economies,
  Folder2save,
  verbose
)
}
\arguments{
\item{ModelType}{A character vector indicating the  estimated model type}

\item{NumOut}{list of computed outputs containing the model fit, IRFs, FEVDs, GIRFs, GFEVDs and Term premia}

\item{WishPdynamicsgraphs}{binary variable: set 1, if the user wishes graphs to be generated; or set 0, otherwise}

\item{WishYieldsgraphs}{binary variable: set 1, if the user wishes graphs to be generated; or set 0, otherwise}

\item{FEVDhoriz}{single numerical vector containing the desired horizon of analysis for the FEVDs}

\item{PathsGraphs}{Path of the folder in which the graphs will be saved}

\item{OutputType}{Available options are 'FEVD' and 'GFEVD'}

\item{Economies}{A character vector containing the names of the economies included in the system.}

\item{Folder2save}{Folder path where the outputs will be stored.}

\item{verbose}{Logical flag controlling function messaging.}
}
\description{
FEVD and GFEVD graphs for all models
}
\section{Available Methods}{

- `autoplot(object, type = "FEVD_Factor")`, `autoplot(object, type = "FEVD_Yields")`,
  `autoplot(object, type = "GFEVD_Yields")`, `autoplot(object, type = "GFEVD_Yields")`. \cr

 - For JLL-based models other option available are: `autoplot(object, type = "FEVD_Factor-_Ortho")`,
 `autoplot(object, type = "FEVD_Yields_Ortho")`, `autoplot(object, type = "GFEVD_Yields_Ortho")`,
  `autoplot(object, type = "GFEVD_Yields_Ortho")`.
}

\examples{
data("NumOutEx")
ModelType <- "JPS original"
Economy <- "Brazil"
FEVDhoriz <- 20

FEVDandGFEVDgraphs(ModelType, NumOutEx, WishPdynamicsgraphs = 0, WishYieldsgraphs= 1, FEVDhoriz,
                  PathsGraphs = NULL, OutputType = "FEVD", Economy,
                  Folder2save = NULL, verbose = FALSE)


}
