% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GraphicalOutputs.R
\name{RiskFactorsGraphs}
\alias{RiskFactorsGraphs}
\title{Spanned and unspanned factors plot}
\usage{
RiskFactorsGraphs(
  ModelType,
  WishRFgraphs,
  ModelOutputs,
  Economies,
  FactorLabels,
  Folder2save,
  verbose
)
}
\arguments{
\item{ModelType}{character. Estimated model type. Permissible choices: "JPS original", "JPS global", "GVAR single", "JPS multi", "GVAR multi", "JLL original", "JLL No DomUnit", "JLL joint Sigma".}

\item{WishRFgraphs}{logical. Set TRUE to generate graphs, FALSE otherwise.}

\item{ModelOutputs}{list. Model parameter estimates (see \code{\link{Optimization}}).}

\item{Economies}{character vector. Names of the \code{C} economies included in the system.}

\item{FactorLabels}{list. Labels for all variables in the model.}

\item{Folder2save}{character. Folder path where the outputs will be stored.}

\item{verbose}{logical. Flag controlling function messaging.}
}
\description{
Spanned and unspanned factors plot
}
\section{Available Methods}{

- `autoplot(object, type = "RiskFactors")`
}

\examples{
data("ParaSetEx")
# Adapt factor labels according to the example
ModelType <- "JPS original"
Economy <- "Brazil"
FacLab <- LabFac(N = 1, DomVar = "Eco_Act", GlobalVar = "Gl_Eco_Act", Economy, ModelType)

RiskFactorsGraphs(ModelType,
  WishRFgraphs = FALSE, ParaSetEx, Economy, FacLab,
  Folder2save = NULL, verbose = FALSE
)

}
