% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSR.R
\name{Strate_CSR}
\alias{Strate_CSR}
\title{Calculate CSR (Competition-Stress-Ruderal) Strategy}
\usage{
Strate_CSR(LA, LDMC, SLA)
}
\arguments{
\item{LA}{Leaf area in mm^2}

\item{LDMC}{Leaf dry matter content in \%}

\item{SLA}{Specific leaf area in mm^2/mg}
}
\value{
A list containing:
\itemize{
\item \code{C}: Proportion of competition strategy
\item \code{S}: Proportion of stress-tolerance strategy
\item \code{R}: Proportion of ruderal strategy
\item \code{type}: Type of CSR strategy
}
}
\description{
This function calculates the CSR strategy based on leaf traits.
}
\examples{
Strate_CSR(LA = 369615.7, LDMC = 25.2, SLA = 17.4)

}
\references{
\enumerate{
\item Grime, J.P. (1974). Vegetation classification by reference to strategies. Nature, 250, 26–31.
\item Pierce, S., Negreiros, D., Cerabolini, B.E.L., Kattge, J., Díaz, S., et al. (2017). A global method for calculating plant CSR ecological strategies applied across biomes world-wide. Funct Ecol, 31: 444-457.
}
}
