% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mmsNiWpdfC}
\alias{mmsNiWpdfC}
\title{C++ implementation of multivariate structured Normal inverse Wishart probability density function for multiple inputs}
\usage{
mmsNiWpdfC(xi, psi, Sigma, U_xi0, U_psi0, U_B0, U_Sigma0, U_df0, Log = TRUE)
}
\arguments{
\item{xi}{data matrix of dimensions \code{p x n} where columns contain the observed
mean vectors.}

\item{psi}{data matrix of dimensions \code{p x n} where columns contain the observed
skew parameter vectors.}

\item{Sigma}{list of length \code{n} of observed variance-covariance matrices,
each of dimensions \code{p x p}.}

\item{U_xi0}{mean vectors matrix of dimension \code{p x K}, \code{K} being the number of
distributions for which the density probability has to be evaluated.}

\item{U_psi0}{skew parameter vectors matrix of dimension \code{p x K}.}

\item{U_B0}{list of length \code{K} of structured scale matrices,
each of dimensions \code{p x p}.}

\item{U_Sigma0}{list of length \code{K} of variance-covariance matrices,
each of dimensions \code{p x p}.}

\item{U_df0}{vector of length \code{K} of degree of freedom parameters.}

\item{Log}{logical flag for returning the log of the probability density
function. Defaults is \code{TRUE}.}
}
\value{
matrix of densities of dimension \code{K x n}
}
\description{
C++ implementation of multivariate structured Normal inverse Wishart probability density function for multiple inputs
}
\references{
Hejblum BP, Alkhassim C, Gottardo R, Caron F and Thiebaut R (2019) 
Sequential Dirichlet Process Mixtures of Multivariate Skew t-distributions for 
Model-based Clustering of Flow Cytometry Data. The Annals of Applied Statistics, 
13(1): 638-660. <doi: 10.1214/18-AOAS1209>. <arXiv: 1702.04407>. 
\url{https://arxiv.org/abs/1702.04407} \doi{10.1214/18-AOAS1209}
}
