\name{samplehouseholds}
\alias{samplehouseholds}
\title{
Rcpp implementation for sampling household data without constraints.
}
\description{
Rcpp implementation for sampling household data without constraints.
}
\usage{
samplehouseholds(phi, omega, pi, d, lambda, currrentbatch, nHouseholds, householdsize,
      HeadAtGroupLevel, Parallel)
}
\arguments{
  \item{phi}{Matrix of posterior samples for the individual-level probabilities for each individual-level variable by each pair of group-level and individual-level latent classes.}
  \item{omega}{Matrix of the probabilities for the individual-level latent classes by the group-level latent classes.}
  \item{pi}{Vector of the probabilities for the group-level latent classes.}
  \item{d}{Vector containing the number of levels for each of the indiviual-level variables.}
  \item{lambda}{A list of matrices of the group-level probabilities for each group-level variable by the group-level latent classes. Each matrix in the list is for each group-level variable.}
  \item{currrentbatch}{
  The current batch number for the household data to be generated. The household ID will be generated based on this batch number.
}
  \item{nHouseholds}{
  The number of households to be generated by one call to this function.
}
  \item{householdsize}{
  The size of the households to be generated.
}
\item{HeadAtGroupLevel}{
  Logical indicator for running the model that codes household head at the group level.
}
\item{Parallel}{
  Logical indicator for running the function in parallel mode.
}
}
\details{
 This function allows the model to generate a batch of \verb{nHouseholds} with each household of size \verb{householdsize}. The generated household data will include both possible and impossible households. Use \verb{samplehouseholds} when the household head is included as an individual within the household.
}
\value{
A data matrix with each row for one household.
}

\author{
Quanli Wang
}
\keyword{sampler}
\keyword{household data without constraint}
