% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.blrmfit}
\alias{summary.blrmfit}
\title{Summarise model results}
\usage{
\method{summary}{blrmfit}(
  object,
  newdata,
  transform = !predictive,
  prob = 0.95,
  interval_prob,
  predictive = FALSE,
  ...
)
}
\arguments{
\item{object}{fitted model object}

\item{newdata}{optional data frame specifying for what to predict;
if missing, then the data of the input model \code{object} is
used}

\item{transform}{logical (defaults to \code{FALSE}) indicating if
the linear predictor on the logit link scale is transformed
with \code{inv_logit} to the 0-1 response scale.}

\item{prob}{central probability mass to report, i.e. the quantiles
0.5-prob/2 and 0.5+prob/2 are displayed. Multiple central
widths can be specified.}

\item{interval_prob}{optional vector of sorted quantiles for which
the interval probabilities are calculated}

\item{predictive}{logical indicates if the posterior predictive is
being summarized. Defaults to \code{FALSE}.}

\item{...}{not used in this function}
}
\value{
Returns a \code{data.frame} of the key summaries of the
    posterior mean, standard deviation, central probability
    interval, median and optional interval probabilities. Each row
    of the \code{data.frame} corresponds to the respective input
    data which is by default the same data set as used for the
    \code{\link{blrm_exnex}} analysis or the data specified in the
    \code{newdata} argument.
}
\description{
Provides model summaries for \code{\link{blrm_exnex}} and
\code{\link{blrm_trial}} analyses.
}
\details{
The calculated posterior summaries are returned as a
\code{data.frame} and contain optional interval probabilites for
the specified vector of sorted quantiles. These summaries are
calculated on the response scale by default and can be obtained on
the link scale when setting \code{transform=FALSE}.

When the results are requested for the predictive distribution with
\code{predictive=TRUE}, then the link scale refers to the total
counts while the transformed scale divides the (predictive) counts
by the number of trials such that results are on the 0-1 scale.
}
\examples{
## Setting up dummy sampling for fast execution of example
## Please use 4 chains and 100x more warmup & iter in practice
.user_mc_options <- options(OncoBayes2.MC.warmup=10, OncoBayes2.MC.iter=20, OncoBayes2.MC.chains=1)

example_model("single_agent")

## obtain underdosing (0-0.16), target dosing (0.16-0.33) and
## overdosing (0.33-1) probabilities
summary(blrmfit, interval_prob=c(0,0.16,0.33,1))

## obtain predictive distribution for respective cohorts and
## calculate probability for no event, 1 event or >1 event
## note that this does the calculation for the cohort sizes
## as put into the data-set
summary(blrmfit, interval_prob=c(-1,0,1,10), predictive=TRUE)

## to obtain the predictive for a cohort-size of 6 for all patients
## in the data-set one would need to use the newdata argument, e.g.
summary(blrmfit, newdata=transform(hist_SA, num_patients=6),
                 interval_prob=c(-1,0,1,10), predictive=TRUE)

## Recover user set sampling defaults
options(.user_mc_options)

}
