% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/U01-data-validation.R
\name{validate_censor_formula}
\alias{validate_censor_formula}
\title{Validate Censoring Formula}
\usage{
validate_censor_formula(censor_formula)
}
\arguments{
\item{censor_formula}{A formula object for the censoring model.
Should be of the form `Surv(time, event) ~ covariates`.
Use `Surv(time, event) ~ 0` to indicate no censoring adjustment
(all censoring scores set to 1).}
}
\value{
A list containing:
  \item{formula}{The validated formula object, or NULL if RHS is 0
    (no censoring adjustment)}
  \item{time_var}{Character string of the time variable name}
  \item{event_var}{Character string of the event variable name}
}
\description{
Checks that the censoring formula is valid, uses Surv() notation, and
extracts the time and event variable names.
}
\keyword{internal}
