% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgDiagram.R
\name{pkgDiagram}
\alias{pkgDiagram}
\title{pkgDiagram}
\usage{
pkgDiagram(repo, verbose = FALSE, ...)
}
\arguments{
\item{repo}{(\link[PaRe]{Repository})\cr
Repository object.}

\item{verbose}{(\link[base]{logical})\cr
Turn verbose messages on or off.}

\item{...}{Optional other parameters for \link[DiagrammeR]{grViz}.}
}
\value{
(\code{htmlwidget})\cr
Diagram \code{htmlwidget} object. See \link[htmlwidgets]{createWidget}
}
\description{
Creates a diagram of all defined functions in a package.
}
\examples{
fetchedRepo <- tryCatch(
  {
    # Set dir to clone repository to.
    tempDir <- tempdir()
    pathToRepo <- file.path(tempDir, "glue")

    # Clone repo
    git2r::clone(
      url = "https://github.com/tidyverse/glue.git",
      local_path = pathToRepo
    )

    # Create instance of Repository object.
    repo <- PaRe::Repository$new(path = pathToRepo)

    # Set fetchedRepo to TRUE if all goes well.
    TRUE
  },
  error = function(e) {
    # Set fetchedRepo to FALSE if an error is encountered.
    FALSE
  },
  warning = function(w) {
    # Set fetchedRepo to FALSE if a warning is encountered.
    FALSE
  }
)

if (fetchedRepo) {
  # Run pkgDiagram on the Repository object.
  pkgDiagram(repo = repo)
}
}
