% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{import.smvshift}
\alias{import.smvshift}
\title{Load Smoothed Frequency Shift}
\usage{
import.smvshift(filename, selected_parent = "sim", backcrossed_parent = "sec")
}
\arguments{
\item{filename}{file containing the allele frequencies as an extended BED6+ file; see vignette for formatting}

\item{selected_parent}{name of the First Parent (that which is Selected for)}

\item{backcrossed_parent}{name of the Second Parent (that which is Backcrossed to)}
}
\value{
loaded data as a bedgraph
}
\description{
Load Smoothed Frequency Shift
}
\examples{
\donttest{
windowed_shifts.filename <- system.file("extdata",
"windowed_shifts.example_data.bed", package = "PopPsiSeqR")
windowed_shifts.bg <- import.smvshift(windowed_shifts.filename)
}
}
