% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_helper.R
\name{ml_make_model}
\alias{ml_make_model}
\title{Model factory for tabular cross-sectional learners}
\usage{
ml_make_model(
  type = c("ridge", "rf", "xgboost", "linear"),
  params = list(),
  nrounds = 200L,
  ...
)
}
\arguments{
\item{type}{One of \code{"ridge"}, \code{"rf"}, \code{"xgboost"}, \code{"linear"}.}

\item{params}{List of model parameters (passed to backend; used by xgboost).}

\item{nrounds}{Integer boosting rounds (xgboost).}

\item{...}{Additional arguments forwarded to the backend.}
}
\value{
A list with functions \code{fit} and \code{predict}.
}
\description{
Returns a pair of closures \code{fit(X,y)} / \code{predict(model, X)} implementing
a chosen learner. Implementations are NA-aware and conservative:
\code{glmnet} ridge drops rows with any non-finite input; \code{ranger} and \code{xgboost}
keep NA in \code{X} as missing; the linear baseline uses \code{lm.fit}.
}
\details{
Optional dependencies: \code{glmnet} (ridge), \code{ranger} (rf), \code{xgboost} (xgboost).
If a backend is not available, use \code{"linear"} or install the package.
}
\examples{
\dontrun{
ridge <- ml_make_model("ridge")
m <- ridge$fit(X_is, y_is)
s <- ridge$predict(m, X_oos)
}
}
