% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_XGBoost.R
\name{pred_XGBoost}
\alias{pred_XGBoost}
\title{Prediction results from XGBoost}
\usage{
pred_XGBoost(x,n.grid=30,xlim,ylim,replicates)
}
\arguments{
\item{x}{A object of class 'xgb.Booster'.}

\item{n.grid}{The grid note number within 'xlim' and 'ylim', default=30.}

\item{xlim}{The range of the absolute value of avg_log2FC used for prediction.}

\item{ylim}{The range of the avg_pct used for prediction.}

\item{replicates}{The replicates number.}
}
\value{
The power estimations from XGBoost.
}
\description{
This function takes the result from 'fit_XGBoost' and make predictions.
}
\examples{
data(power_example)
# Fit the local power surface of avg_log2FC_abs between 1 and 2
avg_log2FC_abs_1_2<-dplyr::filter(power_example,avg_log2FC_abs>1 & avg_log2FC_abs<2)
# Fit the model
bst<-fit_XGBoost(power_example$power,avg_log2FC=power_example$avg_log2FC_abs,
avg_PCT=power_example$mean_pct,replicates=power_example$sample_size)
pred<-pred_XGBoost(bst,n.grid=30,xlim=c(0,1.5),ylim=c(0,0.1),replicates=3)

}
\author{
Lan Shui \email{lshui@mdanderson.org}
}
