% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrInDTCstruc.R
\name{PrInDTCstruc}
\alias{PrInDTCstruc}
\title{Structured subsampling for classification}
\usage{
PrInDTCstruc(datain,classname,ctestv=NA,Struc=NA,vers="d",weight=FALSE,
                Eit=NA,Pit=NA,N=99,Ni=99,undersamp=TRUE,crit="ba",ktest=0,
                stest=integer(length=0),conf.level=0.95,indrep=0,
                minsplit=NA,minbucket=NA,repvar=NA,valdat=datain,thr=0.5)
}
\arguments{
\item{datain}{Input data frame with class factor variable 'classname' and the\cr
influential variables, which need to be factors or numericals (transform logicals and character variables to factors)}

\item{classname}{Name of class variable (character)}

\item{ctestv}{Vector of character strings of forbidden split results;\cr
Example: ctestv <- rbind('variable1 == \{value1, value2\}','variable2 <= value3'), where
character strings specified in 'value1', 'value2' are not allowed as results of a splitting operation in variable 1 in a tree.\cr
For restrictions of the type 'variable <= xxx', all split results in a tree are excluded with 'variable <= yyy' and yyy <= xxx.\cr
Trees with split results specified in 'ctestv' are not accepted during optimization.\cr
A concrete example is: 'ctestv <- rbind('ETH == \{C2a, C1a\}','AGE <= 20')' for variables 'ETH' and 'AGE' and values 'C2a','C1a', and '20';\cr
If no restrictions exist, the default = NA is used.}

\item{Struc}{= list(name,check,labs), cf. description for explanations; Struc not needed for vers="b"; for indrep=1, Struc = list(name);}

\item{vers}{Version of structured subsampling: "a", "b", "c", "d", cf. description; \cr
default = "d"}

\item{weight}{Weights to be used for subsampling of elements of substructure (logical, TRUE or FALSE);
default = FALSE}

\item{Eit}{List of number of elements of substructure (integers); \cr
default = c((Cl-4):Cl), Cl = maximum number of elements in both categories}

\item{Pit}{List of number of predictors (integers)\cr
default = c(max(1,(D-3)):D), D = maximum number of predictors}

\item{N}{Number of repetitions of subsampling from substructure (integer)\cr
default = 0 for vers="b", = 99 otherwise; if vers="b", any input is overwritten by the default}

\item{Ni}{Number of repetitions of subsampling from predictors\cr
default = 0 for vers="a", = 99 for vers="b", = N otherwise; if vers="a", any input is overwritten by the default}

\item{undersamp}{Undersampling of categories of 'classname' to be used ((logical, TRUE or FALSE)\cr
default = TRUE; if indrep=1 or vers="b", undersamp = FALSE}

\item{crit}{Optimisation criterion: "ba" for balanced accuracy, "bat" for balanced accuracy on test sets, "ta" for test accuracy, 
"tal" for test accuracy of continuing parts of length 'ktest' in substructure elements 'stest';\cr
default = "ba"}

\item{ktest}{Length of continuing parts to be tested (for crit="tal");\cr
default = 0}

\item{stest}{Part of substructure to be tested (for crit="tal")(integer vector);\cr
default = integer vector of length 0}

\item{conf.level}{(1 - significance level) in function \code{ctree} (numerical, > 0 and <= 1);\cr
default = 0.95}

\item{indrep}{Indicator for repeated measurements, i.e. more than one observation with the same class for each element;\cr 
for indrep=1, Struc=list(name) only; default = 0}

\item{minsplit}{Minimum number of elements in a node to be splitted;\cr
default = 20}

\item{minbucket}{Minimum number of elements in a node;\cr
default = 7}

\item{repvar}{Values of variable defining the substructure corresponding to valdat in the case of repeated measurements, length = dim(valdat)[1] necessary; default = NA}

\item{valdat}{validation data; default = datain}

\item{thr}{threshold for element classfication: minimum percentage of correct class entries; default = 0.5}
}
\value{
\describe{
  \item{modbest}{Best tree} 
  \item{interp}{Number of interpretable trees, overall number of trees} 
  \item{dmax}{Number of predictors in training set for best tree} 
  \item{ntmax}{Size of training set for best tree} 
  \item{acc1}{Accuracy of best tree on large class} 
  \item{acc2}{Accuracy of best tree on small class }  
  \item{bamax}{Balanced accuracy of best tree} 
  \item{tamax}{Test accuracy of best tree}
  \item{kumin}{Number of elements with misclassified parts longer than 'ktest' for best tree}
  \item{elems}{Elements with long misclassified parts for best tree}
  \item{mindlong}{Indices of long misclassified parts for best tree}
  \item{ind1max}{Elements of 1st category of substructure used by best tree} 
  \item{ind2max}{Elements of 2nd category of substructure used by best tree} 
  \item{indmax}{Predictors used by best tree} 
  \item{bestTrain}{Training set for best tree} 
  \item{bestTest}{Test set for best tree} 
  \item{labs}{labs from Struc} 
  \item{lablarge}{Label of large class} 
  \item{labsmall}{Label of small class} 
  \item{vers}{Version used for structured subsampling} 
  \item{acc1E}{Accuracy of large class on Elements of best tree} 
  \item{acc2E}{Accuracy of small class on Elements of best tree}  
  \item{bamaxE}{Balanced accuracy of best tree on Elements} 
  \item{nam1}{Names of misclassified Elements of large class}
  \item{nam2}{Names of misclassified Elements of small class}
  \item{thr}{Threshold for element classification}
}
}
\description{
The function PrInDTCstruc applies structured subsampling for finding an optimal subsample to model
the relationship between the two-class factor variable 'classname' and all other factor and numerical variables
in the data frame 'datain' by means of 'N' repetitions of subsampling from a substructure and 'Ni' repetitions of subsampling from the predictors.  
The optimization citerion is the balanced accuracy on the validation sample 'valdat' (default is the full input sample 'datain'). 
Other criteria are possible (cf. parameter description of 'crit'). The trees generated from undersampling can be restricted by not accepting trees 
including split results specified in the character strings of the vector 'ctestv'.\cr
The substructure of the observations used for subsampling in modelling is specified by the list 'Struc' which consists of the variable 'name' representing the substructure,
the name 'check' of the variable with the information about the categories of the substructure, and the matrix 'labs' which specifies the values of 'check'
corresponding to two categories in its rows, i.e. in 'labs[1,]' and 'labs[2,]'. The names of the categories have to be specified by \code{rownames(labs)}.\cr
See parameter description of 'Struc' for its specification for 'vers="b"' and 'indrep > 0'.\cr
The number of predictors 'Pit' to be included in the model and the number of elements of the substructure 'Eit' have to be specified (lists allowed), and 
undersampling of the categories of 'classname' can be controlled by 'undersamp=TRUE/FALSE'.\cr
Four different versions of structured subsampling exist: \cr
a) just of the elements in the substructure (possibly with additional undersampling) with parameters 'N' and 'Eit',\cr
b) just of the predictors with parameters 'Ni' and 'Pit', \cr
c) of the predictors and for each subset of predictors subsampling of the elements of the substructure (possibly with additional undersampling) 
with parameters 'N', 'Ni', 'Eit', and 'Pit', and\cr
d) of the elements of the substructure (possibly with additional undersampling) and for each of these subsets subsampling of the predictors 
with the same parameters as version c).\cr
Sampling of the elements of the substructure can be influenced by using weights of the elements ('weights=TRUE') according to the number of appearances of the smaller 
class of 'classnames'. This way, elements with more realisations in the smaller class are preferred in modelling.\cr
The parameters 'conf.level', 'minsplit', and 'minbucket' can be used to control the size of the trees.\cr\cr
The parameter 'indrep' indicates repeated measurement situations ('indrep > 0', only implemented for 'crit="ba"'); default = 0.\cr
Repeated measurements are multiple measurements of the same variable taken on the same subjects (or objects) either under different conditions or over two or more time periods.\cr
The variable with the repeatedly observed subjects (or objects) has to be specified by 'name' in 'Struc'. Only one value of 'classname' is allowed for each value of 'Struc$name'.
In case of 'indrep > 0' it is automatically assumed that the same number of 
subjects (or objects) of the two classes under study have to be used for model building. Possible such numbers can be specified by 'Eit'.\cr
For indrep=1, models are optimized for individual observations and the classes of the substructure elements are subsequently determined via the parameter 'thr'.\cr
For indrep=2, models are optimized so that the criterion "ba" is maximal for the substructure elements taking 'thr' into account.\cr
For indrep > 0 and 'valdat' unequal 'datain', the variable 'repvar' defines the substructure for 'valdat', length = dim(valdat)[1] necessary; default = NA'
}
\details{
See Buschfeld & Weihs (2025), Optimizing decision trees for the analysis of World Englishes and sociolinguistic data. Cambridge University Press, section 4.5.1, for further information.

Standard output can be produced by means of \code{print(name$besttree)} or just \code{name$besttree} as well as \code{plot(name$besttree)} where 'name' is the output data 
frame of the function.\cr
}
\examples{
data <- PrInDT::data_zero
data <- na.omit(data) # cleaned full data: no NAs
# interpretation restrictions (split exclusions)
ctestv <- rbind('ETH == {C2a, C1a}','MLU == {1, 3}') # split exclusions
# substructure
name <- PrInDT::participant_zero
check <- "data$ETH"
labs <- matrix(1:6,nrow=2,ncol=3)
labs[1,] <- c("C1a","C1b","C1c")
labs[2,] <- c("C2a","C2b","C2c")
rownames(labs) <- c("Children 1","Children 2")
Struc <- list(name=name,check=check,labs=labs)
out <- PrInDTCstruc(data,"real",ctestv,Struc,vers="c",weight=TRUE,N=5,Pit=5,conf.level=0.99)
out
plot(out)
# indrep = 1
Struc <- list(name=name)
out <- PrInDTCstruc(data,"real",Struc=Struc,vers="c",Pit=5,Eit=5,N=5,crit="ba",indrep=1,
           conf.level=0.99)

}
