% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/procmod_frame.R
\name{dim.procmod_frame}
\alias{dim.procmod_frame}
\title{Dimensions of a ProcMod Frame.}
\usage{
\method{dim}{procmod_frame}(x)
}
\arguments{
\item{x}{a \code{\link[ProcMod]{procmod_frame}}
object}
}
\description{
Dimension 1 is the number of rows (individus)
shared by the aggregated matrices. Dimension 2
is the number of aggregated matrices
}
\examples{
# Builds a procmod_frame with two random matrices
m1 <- simulate_matrix(10,20)
m2 <- simulate_matrix(10,30)
pmf <- procmod_frame(m1 = m1, m2 = m2)
dim(pmf)

}
\author{
Eric Coissac

Christelle Gonindard-Melodelima
}
