% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_mutual_module}
\alias{get_mutual_module}
\title{Extract the mutually exclusive module.}
\usage{
get_mutual_module(
  module,
  net,
  freq_matrix,
  sur,
  module_sig,
  univarCox_result,
  rate
)
}
\arguments{
\item{module}{The Original modular gene set.}

\item{net}{The local network extracted from PPI network.}

\item{freq_matrix}{The mutations matrix,generated by `get_mut_status`.}

\item{sur}{A nx2 data frame of samples' survival data,the first line is samples' survival event and the second line is samples' overall survival.}

\item{module_sig}{A label for whether the module is a risk factor or a protective factor for survival.}

\item{univarCox_result}{The result of Cox univariate analysis,generated by `get_univarCox_result`.}

\item{rate}{The rate of increase in score,default is 0.05.}
}
\value{
The mutually exclusive module.
}
\description{
The function `get_mutual_module` is used to determine if neighbor genes should be added to the module by calculating the score.
}
\examples{
\donttest{#load the data
data(mut_status)
sur<-system.file("extdata","sur.csv",package = "ProgModule")
sur<-read.delim(sur,sep=",",header=TRUE,row.names = 1)
data(net)
data(module)
data(univarCox_result)
#perform the function `get_mutual_module`.
mutuallyexclusivemodule.example<-get_mutual_module(module,net,freq_matrix=mut_status,sur,
module_sig="risk",univarCox_result,rate=0.05)}
}
