% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{patients_lung_diseases_tbl_df}
\alias{patients_lung_diseases_tbl_df}
\title{Lung Disease Patients}
\format{
A tibble with 5,200 observations and 8 variables:
\describe{
  \item{Age}{Patient age in years (numeric)}
  \item{Gender}{Patient gender (character)}
  \item{Smoking Status}{Smoker or non-smoker status (character)}
  \item{Lung Capacity}{Measured lung function (numeric)}
  \item{Disease Type}{Specific lung condition (character)}
  \item{Treatment Type}{Therapy, medication or surgery received (character)}
  \item{Hospital Visits}{Number of hospital visits (numeric)}
  \item{Recovered}{Recovery status (character)}
}
}
\source{
Data taken from Kaggle: https://www.kaggle.com/datasets/samikshadalvi/lungs-diseases-dataset
}
\usage{
data(patients_lung_diseases_tbl_df)
}
\description{
This dataset, patients_lung_diseases_tbl_df, is a tibble containing detailed clinical information
about 5,200 patients with various lung conditions, including demographics, smoking status,
lung capacity measurements, disease types, treatments received, hospital visits, and recovery status.
}
\details{
The dataset name has been kept as 'patients_lung_diseases_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
PulmoDataSets package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble object. The original content has not been modified
in any way.
}
