% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRR.R
\name{plotRR}
\alias{plotRR}
\title{Plot the RRphylo output onto the phylogenetic tree}
\usage{
plotRR(RR,y,multivariate=NULL)
}
\arguments{
\item{RR}{an object produced by \code{\link{RRphylo}}.}

\item{y}{the vector/matrix of phenotypic values used to perform
\code{\link{RRphylo}}.}

\item{multivariate}{if \code{\link{RRphylo}} was performed on multivariate data, this
argument indicates whether individual rates for each variables (\code{=
"multiple.rates"}) or the norm2 vector of multivariate rates (\code{=
"rates"}) should be plotted.}
}
\value{
The function returns a list of functions:

\strong{$plotRRphen} charts phenotypic values along the tree branches.
 Phenotypes at tips are taken as they are from the \code{y} object.
 Phenotypic values for internal branches are derived from the \code{RR$aces}
 object. The usage is:
 \code{...$plotRRphen(variable=NULL,tree.args=NULL,color.pal=NULL,colorbar.args=list())},
 where \code{variable} is the index or name of the variable to be plotted in
 case of multivariate data, \code{tree.args} is a list of further arguments
 passed to the function \code{plot.phylo} plus a logical indicating whether
 the tree should be ladderized  before plotting (see examples below),
 \code{color.pal} is a function to generate the color palette, and
 \code{colorbar.args} is a list of further arguments passed to the function
 \code{\link{colorbar}} (if \code{= NULL} the bar is not plotted).

\strong{$plotRRrates} charts evolutionary rate values along the tree
 branches. The usage is identical to \code{$plotRRphen}. In case of
 multivariate data and \code{multivariate = "rates"}, the argument
 \code{variable} can be left unspecified.
}
\description{
This function generates customized functions to plot the
 phylogenetic tree (as returned by \code{\link{RRphylo}}) with branches
 colored according to phenotypic values or phenotypic evolutionary rates.
}
\examples{
\dontrun{
data("DataApes")
DataApes$PCstage->PCstage
DataApes$Tstage->Tstage
cc<- 2/parallel::detectCores()

RRphylo(tree=Tstage,y=PCstage,clus=cc)->RRstage

plotRR(RRstage,y=PCstage,multivariate="multiple.rates")->pRR1
pRR1$plotRRphen(variable=1,tree.args=list(edge.width=2),color.pal=rainbow,
               colorbar.args = list(x="bottomleft",labs.adj=0.7,xpd=TRUE))
pRR1$plotRRrates(variable=2,tree.args=list(edge.width=2,direction="leftwards",ladderize=TRUE),
                color.pal=rainbow,colorbar.args = list(x="topright",labs.adj=0.7,xpd=TRUE))


plotRR(RRstage,y=PCstage,multivariate="rates")->pRR2
pRR2$plotRRrates(tree.args=list(edge.width=2),
                color.pal=hcl.colors,
                colorbar.args = list(x="topleft",labs.adj=0.7,xpd=TRUE,title.pos="bottom"))
}
}
\seealso{
\href{../doc/RRphylo.html}{\code{RRphylo} vignette}

\href{../doc/Plotting-tools.html#plotRR}{\code{plotRR} vignette}

\href{../doc/RRphylo.html}{\code{RRphylo} vignette}

\href{../doc/Plotting-tools.html}{\code{plotRR} vignette}
}
\author{
Silvia Castiglione, Pasquale Raia
}
