/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.adtree;

import java.io.Serializable;
import java.util.Enumeration;
import weka.classifiers.trees.ADTree;
import weka.classifiers.trees.adtree.Splitter;
import weka.core.FastVector;

public final class PredictionNode
implements Serializable,
Cloneable {
    private double value;
    private FastVector children;

    public PredictionNode(double d) {
        this.value = d;
        this.children = new FastVector();
    }

    public final void setValue(double d) {
        this.value = d;
    }

    public final double getValue() {
        return this.value;
    }

    public final FastVector getChildren() {
        return this.children;
    }

    public final Enumeration children() {
        return this.children.elements();
    }

    public final void addChild(Splitter splitter, ADTree aDTree) {
        Cloneable cloneable;
        Splitter splitter2 = null;
        Object object = this.children();
        while (object.hasMoreElements()) {
            cloneable = (Splitter)object.nextElement();
            if (!splitter.equalTo((Splitter)cloneable)) continue;
            splitter2 = cloneable;
            break;
        }
        if (splitter2 == null) {
            object = (Splitter)splitter.clone();
            this.setOrderAddedSubtree((Splitter)object, aDTree);
            this.children.addElement(object);
        } else {
            for (int i = 0; i < splitter.getNumOfBranches(); ++i) {
                cloneable = splitter2.getChildForBranch(i);
                PredictionNode predictionNode = splitter.getChildForBranch(i);
                if (cloneable == null || predictionNode == null) continue;
                ((PredictionNode)cloneable).merge(predictionNode, aDTree);
            }
        }
    }

    public final Object clone() {
        PredictionNode predictionNode = new PredictionNode(this.value);
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            predictionNode.children.addElement((Splitter)((Splitter)enumeration.nextElement()).clone());
        }
        return predictionNode;
    }

    public final void merge(PredictionNode predictionNode, ADTree aDTree) {
        this.value += predictionNode.value;
        Enumeration enumeration = predictionNode.children();
        while (enumeration.hasMoreElements()) {
            this.addChild((Splitter)enumeration.nextElement(), aDTree);
        }
    }

    private final void setOrderAddedSubtree(Splitter splitter, ADTree aDTree) {
        splitter.orderAdded = aDTree.nextSplitAddedOrder();
        for (int i = 0; i < splitter.getNumOfBranches(); ++i) {
            PredictionNode predictionNode = splitter.getChildForBranch(i);
            if (predictionNode == null) continue;
            Enumeration enumeration = predictionNode.children();
            while (enumeration.hasMoreElements()) {
                this.setOrderAddedSubtree((Splitter)enumeration.nextElement(), aDTree);
            }
        }
    }
}

